/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.block;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.zeroregard.ars_technica.Config;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import com.zeroregard.ars_technica.registry.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class TransmutationTurretTile
extends BasicSpellTurretTile {
    public TransmutationTurretTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityRegistry.TRANSMUTATION_TURRET_BLOCK_ENTITY.get(), pos, state);
    }

    @NotNull
    public BlockEntityType<?> getType() {
        return (BlockEntityType)EntityRegistry.TRANSMUTATION_TURRET_BLOCK_ENTITY.get();
    }

    public int getManaCost() {
        Spell spell = this.spellCaster.getSpell();
        double multiplier = (Double)Config.Common.TRANSMUTATION_TURRET_SOURCE_COST_MULTIPLIER.get();
        return (int)((double)spell.getCost() * multiplier);
    }

    public void shootSpell() {
        Level level;
        BlockPos pos = this.getBlockPos();
        if (this.spellCaster.getSpell().isEmpty() || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        int manaCost = this.getManaCost();
        if (manaCost > 0 && SourceUtil.takeSourceMultipleWithParticles((BlockPos)pos, (Level)world, (int)10, (int)manaCost) == null) {
            return;
        }
        Networking.sendToNearbyClient((Level)world, (BlockPos)pos, (CustomPacketPayload)new PacketOneShotAnimation(pos));
        Position iposition = BasicSpellTurret.getDispensePosition((BlockPos)pos, (Direction)((Direction)world.getBlockState(pos).getValue((Property)BasicSpellTurret.FACING)));
        Direction direction = (Direction)world.getBlockState(pos).getValue((Property)BasicSpellTurret.FACING);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        fakePlayer.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        TransmutationTurretSpellResolver resolver = new TransmutationTurretSpellResolver(new SpellContext((Level)world, this.spellCaster.getSpell(), (LivingEntity)fakePlayer, (IWrappedCaster)new TileCaster((BlockEntity)this, SpellContext.CasterType.TURRET)));
        if (resolver.castType != null && BasicSpellTurret.TURRET_BEHAVIOR_MAP.containsKey(resolver.castType)) {
            ((ITurretBehavior)BasicSpellTurret.TURRET_BEHAVIOR_MAP.get(resolver.castType)).onCast((SpellResolver)resolver, world, pos, (Player)fakePlayer, iposition, direction);
        }
    }

    static class TransmutationTurretSpellResolver
    extends EntitySpellResolver {
        public TransmutationTurretSpellResolver(SpellContext context) {
            super(context);
        }

        public boolean hasFocus(ItemStack stack) {
            return this.hasFocus(stack.getItem());
        }

        public boolean hasFocus(Item item) {
            if (item == ItemRegistry.TRANSMUTATION_FOCUS.get()) {
                return true;
            }
            return super.hasFocus(item);
        }

        public SpellResolver getNewResolver(SpellContext context) {
            return new TransmutationTurretSpellResolver(context);
        }
    }
}

