/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gripe._90.megacells.definition.MEGAComponents;
import gripe._90.megacells.definition.MEGAItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DecompressionPattern
implements IPatternDetails {
    private final AEItemKey definition;
    private final ItemStack from;
    private final ItemStack to;

    public DecompressionPattern(ItemStack from, ItemStack to) {
        this.from = from;
        this.to = to;
        ItemStack definition = new ItemStack(MEGAItems.SKY_STEEL_INGOT);
        definition.set(MEGAComponents.ENCODED_DECOMPRESSION_PATTERN, (Object)new Encoded(from, to));
        this.definition = AEItemKey.of((ItemStack)definition);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return new IPatternDetails.IInput[]{new Input(this.from)};
    }

    public List<GenericStack> getOutputs() {
        return Collections.singletonList(new GenericStack((AEKey)AEItemKey.of((ItemStack)this.to), (long)this.to.getCount()));
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == this.getClass() && ((DecompressionPattern)o).definition.equals((Object)this.definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public record Encoded(ItemStack from, ItemStack to) {
        public static final Codec<Encoded> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("from").forGetter(Encoded::from), (App)ItemStack.CODEC.fieldOf("to").forGetter(Encoded::to)).apply((Applicative)instance, Encoded::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Encoded> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, Encoded::from, (StreamCodec)ItemStack.STREAM_CODEC, Encoded::to, Encoded::new);
    }

    private record Input(ItemStack stack) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)AEItemKey.of((ItemStack)this.stack), (long)this.stack.getCount())};
        }

        public long getMultiplier() {
            return 1L;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

