/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.block;

import appeng.block.crafting.ICraftingUnitType;
import appeng.core.definitions.BlockDefinition;
import gripe._90.megacells.definition.MEGABlocks;
import net.minecraft.world.item.Item;

public enum MEGACraftingUnitType implements ICraftingUnitType
{
    UNIT(0, "unit"),
    ACCELERATOR(0, "accelerator"),
    STORAGE_1M(1, "1m_storage"),
    STORAGE_4M(4, "4m_storage"),
    STORAGE_16M(16, "16m_storage"),
    STORAGE_64M(64, "64m_storage"),
    STORAGE_256M(256, "256m_storage"),
    MONITOR(0, "monitor");

    private final int storageMb;
    private final String affix;

    private MEGACraftingUnitType(int storageMb, String affix) {
        this.storageMb = storageMb;
        this.affix = affix;
    }

    public long getStorageBytes() {
        return 0x100000L * (long)this.storageMb;
    }

    public int getAcceleratorThreads() {
        return this == ACCELERATOR ? 4 : 0;
    }

    public String getAffix() {
        return this.affix;
    }

    public BlockDefinition<?> getDefinition() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> MEGABlocks.MEGA_CRAFTING_UNIT;
            case 1 -> MEGABlocks.CRAFTING_ACCELERATOR;
            case 2 -> MEGABlocks.CRAFTING_STORAGE_1M;
            case 3 -> MEGABlocks.CRAFTING_STORAGE_4M;
            case 4 -> MEGABlocks.CRAFTING_STORAGE_16M;
            case 5 -> MEGABlocks.CRAFTING_STORAGE_64M;
            case 6 -> MEGABlocks.CRAFTING_STORAGE_256M;
            case 7 -> MEGABlocks.CRAFTING_MONITOR;
        };
    }

    public Item getItemFromType() {
        return this.getDefinition().asItem();
    }
}

