/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.registry.tag.CommonTags;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.iceandfire.world.structure.DragonRoostStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.LootTable;

public class LightningDragonRoostStructure
extends DragonRoostStructure {
    public static final MapCodec<LightningDragonRoostStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LightningDragonRoostStructure.settingsCodec((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, LightningDragonRoostStructure::new));

    protected LightningDragonRoostStructure(Structure.StructureSettings config) {
        super(config);
    }

    @Override
    protected DragonRoostStructure.DragonRoostPiece createPiece(BoundingBox boundingBox, boolean isMale) {
        return new LightningDragonRoostPiece(0, boundingBox, (Block)IafBlocks.COPPER_PILE.get(), isMale);
    }

    @Override
    protected double getGenerateChance() {
        return (Double)IafCommonConfig.INSTANCE.worldGen.generateLightningDragonRoostChance.getValue();
    }

    public StructureType<?> type() {
        return (StructureType)IafStructureTypes.LIGHTNING_DRAGON_ROOST.get();
    }

    public static class LightningDragonRoostPiece
    extends DragonRoostStructure.DragonRoostPiece {
        private static final ResourceLocation DRAGON_CHEST = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"chest/lightning_dragon_roost");

        protected LightningDragonRoostPiece(int length, BoundingBox boundingBox, Block treasureBlock, boolean isMale) {
            super((StructurePieceType)IafStructurePieces.LIGHTNING_DRAGON_ROOST.get(), length, boundingBox, treasureBlock, isMale);
        }

        public LightningDragonRoostPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.LIGHTNING_DRAGON_ROOST.get(), nbt);
        }

        @Override
        protected EntityType<? extends EntityDragonBase> getDragonType() {
            return (EntityType)IafEntities.LIGHTNING_DRAGON.get();
        }

        @Override
        protected ResourceKey<LootTable> getRoostLootTable() {
            return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)DRAGON_CHEST);
        }

        @Override
        protected BlockState transform(BlockState state) {
            Block block = null;
            if (state.is(Blocks.GRASS_BLOCK)) {
                block = (Block)IafBlocks.CRACKLED_GRASS.get();
            } else if (state.is(Blocks.DIRT_PATH)) {
                block = (Block)IafBlocks.CRACKLED_DIRT_PATH.get();
            } else if (state.is(CommonTags.Blocks.GRAVELS)) {
                block = (Block)IafBlocks.CRACKLED_GRAVEL.get();
            } else if (state.is(BlockTags.DIRT)) {
                block = (Block)IafBlocks.CRACKLED_DIRT.get();
            } else if (state.is(CommonTags.Blocks.STONES)) {
                block = (Block)IafBlocks.CRACKLED_STONE.get();
            } else if (state.is(CommonTags.Blocks.COBBLESTONES)) {
                block = (Block)IafBlocks.CRACKLED_COBBLESTONE.get();
            } else if (state.is(BlockTags.LOGS) || state.is(BlockTags.PLANKS)) {
                block = (Block)IafBlocks.ASH.get();
            } else if (state.is(IafBlockTags.GRASSES) || state.is(BlockTags.LEAVES) || state.is(BlockTags.FLOWERS) || state.is(BlockTags.CROPS)) {
                block = Blocks.AIR;
            }
            if (block != null) {
                return block.defaultBlockState();
            }
            return state;
        }

        @Override
        protected void handleCustomGeneration(WorldGenLevel world, BlockPos origin, RandomSource random, BlockPos position, double distance) {
            if (distance > 0.05 && random.nextInt(800) == 0) {
                this.generateSpire((LevelAccessor)world, random, this.getSurfacePosition(world, position));
            }
            if (distance > 0.05 && random.nextInt(1000) == 0) {
                this.generateSpike((LevelAccessor)world, random, this.getSurfacePosition(world, position), GenerationConstants.HORIZONTALS[random.nextInt(3)]);
            }
        }

        private void generateSpike(LevelAccessor worldIn, RandomSource rand, BlockPos position, Direction direction) {
            int radius = 5;
            for (int i = 0; i < 5; ++i) {
                int j = Math.max(0, radius - (int)((float)i * 1.75f));
                int l = radius - i;
                int k = Math.max(0, radius - (int)((float)i * 1.5f));
                float f = (float)(j + l) * 0.333f + 0.5f;
                BlockPos up = position.above().relative(direction, i);
                int xOrZero = direction.getAxis() == Direction.Axis.Z ? j : 0;
                int zOrZero = direction.getAxis() == Direction.Axis.Z ? 0 : k;
                for (BlockPos blockpos : BlockPos.betweenClosedStream((BlockPos)up.offset(-xOrZero, -l, -zOrZero), (BlockPos)up.offset(xOrZero, l, zOrZero)).map(BlockPos::immutable).collect(Collectors.toSet())) {
                    if (!(blockpos.distSqr((Vec3i)position) <= (double)(f * f))) continue;
                    int height = Math.max(blockpos.getY() - up.getY(), 0);
                    if (i == 0) {
                        if (!(rand.nextFloat() < (float)height * 0.3f)) continue;
                        worldIn.setBlock(blockpos, ((Block)IafBlocks.CRACKLED_STONE.get()).defaultBlockState(), 2);
                        continue;
                    }
                    worldIn.setBlock(blockpos, ((Block)IafBlocks.CRACKLED_STONE.get()).defaultBlockState(), 2);
                }
            }
        }

        private void generateSpire(LevelAccessor worldIn, RandomSource rand, BlockPos position) {
            int height = 5 + rand.nextInt(5);
            Direction bumpDirection = Direction.NORTH;
            for (int i = 0; i < height; ++i) {
                worldIn.setBlock(position.above(i), ((Block)IafBlocks.CRACKLED_STONE.get()).defaultBlockState(), 2);
                if (rand.nextBoolean()) {
                    bumpDirection = bumpDirection.getClockWise();
                }
                int offset = 1;
                if (i < 4) {
                    worldIn.setBlock(position.above(i).north(), ((Block)IafBlocks.CRACKLED_GRAVEL.get()).defaultBlockState(), 2);
                    worldIn.setBlock(position.above(i).south(), ((Block)IafBlocks.CRACKLED_GRAVEL.get()).defaultBlockState(), 2);
                    worldIn.setBlock(position.above(i).east(), ((Block)IafBlocks.CRACKLED_GRAVEL.get()).defaultBlockState(), 2);
                    worldIn.setBlock(position.above(i).west(), ((Block)IafBlocks.CRACKLED_GRAVEL.get()).defaultBlockState(), 2);
                    offset = 2;
                }
                if (i >= height - 2) continue;
                worldIn.setBlock(position.above(i).relative(bumpDirection, offset), ((Block)IafBlocks.CRACKLED_COBBLESTONE.get()).defaultBlockState(), 2);
            }
        }
    }
}

