/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.handler;

import com.iafenvoy.iceandfire.data.delegate.DragonForgePropertyDelegate;
import com.iafenvoy.iceandfire.registry.IafScreenHandlers;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DragonForgeScreenHandler
extends AbstractContainerMenu {
    protected final Level world;
    private final Container tileFurnace;
    private final DragonForgePropertyDelegate propertyDelegate;
    public final int fireType;

    public DragonForgeScreenHandler(int i, Inventory playerInventory) {
        this(i, (Container)new SimpleContainer(3), playerInventory, new DragonForgePropertyDelegate());
    }

    public DragonForgeScreenHandler(int id, Container furnaceInventory, Inventory playerInventory, DragonForgePropertyDelegate propertyDelegate) {
        super((MenuType)IafScreenHandlers.DRAGON_FORGE_SCREEN.get(), id);
        this.tileFurnace = furnaceInventory;
        this.world = playerInventory.player.level();
        this.propertyDelegate = propertyDelegate;
        this.addDataSlots(this.propertyDelegate);
        this.fireType = this.propertyDelegate.fireType;
        this.addSlot(new Slot(furnaceInventory, 0, 68, 34));
        this.addSlot(new Slot(furnaceInventory, 1, 86, 34));
        this.addSlot((Slot)new FurnaceResultSlot(playerInventory.player, furnaceInventory, 2, 148, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public boolean stillValid(Player playerIn) {
        return this.tileFurnace.stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index != 1 && index != 0 ? (this.fireType == 0 ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : index < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false))) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public DragonForgePropertyDelegate getPropertyDelegate() {
        return this.propertyDelegate;
    }
}

