/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.particle;

import com.iafenvoy.iceandfire.render.entity.RenderSiren;
import com.iafenvoy.iceandfire.render.model.ModelSiren;
import com.iafenvoy.iceandfire.util.Color4i;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ParticleSirenAppearance
extends Particle {
    private final Model model = new ModelSiren();
    private final int sirenType;

    public ParticleSirenAppearance(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, int sirenType) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.gravity = 0.0f;
        this.lifetime = 30;
        this.sirenType = sirenType;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float f = ((float)this.age + partialTicks) / (float)this.lifetime;
        float f1 = 0.05f + 0.5f * Mth.sin((float)(f * (float)Math.PI));
        PoseStack matrixstack = new PoseStack();
        matrixstack.mulPose(renderInfo.rotation());
        matrixstack.mulPose(Axis.XP.rotationDegrees(150.0f * f - 60.0f));
        matrixstack.scale(-1.0f, -1.0f, 1.0f);
        matrixstack.translate(0.0, (double)-1.101f, 1.5);
        MultiBufferSource.BufferSource irendertypebuffer$impl = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer ivertexbuilder = irendertypebuffer$impl.getBuffer(RenderType.entityTranslucent((ResourceLocation)RenderSiren.getSirenOverlayTexture(this.sirenType)));
        this.model.renderToBuffer(matrixstack, ivertexbuilder, 0xF000F0, OverlayTexture.NO_OVERLAY, new Color4i(1.0, 1.0, 1.0, f1).getIntValue());
        irendertypebuffer$impl.endBatch();
    }
}

