/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.particle;

import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class CockatriceBeamRender {
    public static final RenderType TEXTURE_BEAM = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/cockatrice/beam.png"));

    private static void vertex(VertexConsumer consumer, Matrix4f matrix4f, PoseStack.Pose entry, float x, float y, float z, int red, int green, int blue, float u, float v) {
        consumer.addVertex(matrix4f, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(entry, 0.0f, 1.0f, 0.0f);
    }

    public static void render(Entity entityIn, Entity targetEntity, PoseStack matrixStackIn, MultiBufferSource bufferIn, float partialTicks) {
        float f = 1.0f;
        if (entityIn instanceof EntityCockatrice) {
            EntityCockatrice cockatrice = (EntityCockatrice)entityIn;
            f = cockatrice.getAttackAnimationScale(partialTicks);
        }
        float f1 = (float)entityIn.level().getGameTime() + partialTicks;
        float f2 = f1 * 0.5f % 1.0f;
        float f3 = entityIn.getEyeHeight();
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, (double)f3, 0.0);
        Vec3 Vector3d = CockatriceBeamRender.getPosition(targetEntity, (double)targetEntity.getBbHeight() * 0.5, partialTicks);
        Vec3 Vector3d1 = CockatriceBeamRender.getPosition(entityIn, f3, partialTicks);
        Vec3 Vector3d2 = Vector3d.subtract(Vector3d1);
        float f4 = (float)(Vector3d2.length() + 1.0);
        Vector3d2 = Vector3d2.normalize();
        float f5 = (float)Math.acos(Vector3d2.y);
        float f6 = (float)Math.atan2(Vector3d2.z, Vector3d2.x);
        matrixStackIn.mulPose(Axis.YP.rotation(1.5707964f - f6));
        matrixStackIn.mulPose(Axis.XP.rotation(f5));
        float f7 = f1 * 0.05f * -1.5f;
        float f8 = f * f;
        int j = 64 + (int)(f8 * 191.0f);
        int k = 32 + (int)(f8 * 191.0f);
        int l = 128 - (int)(f8 * 64.0f);
        float f11 = Mth.cos((float)(f7 + 2.3561945f)) * 0.282f;
        float f12 = Mth.sin((float)(f7 + 2.3561945f)) * 0.282f;
        float f13 = Mth.cos((float)(f7 + 0.7853982f)) * 0.282f;
        float f14 = Mth.sin((float)(f7 + 0.7853982f)) * 0.282f;
        float f15 = Mth.cos((float)(f7 + 3.926991f)) * 0.282f;
        float f16 = Mth.sin((float)(f7 + 3.926991f)) * 0.282f;
        float f17 = Mth.cos((float)(f7 + 5.4977875f)) * 0.282f;
        float f18 = Mth.sin((float)(f7 + 5.4977875f)) * 0.282f;
        float f19 = Mth.cos((float)(f7 + (float)Math.PI)) * 0.2f;
        float f20 = Mth.sin((float)(f7 + (float)Math.PI)) * 0.2f;
        float f21 = Mth.cos((float)(f7 + 0.0f)) * 0.2f;
        float f22 = Mth.sin((float)(f7 + 0.0f)) * 0.2f;
        float f23 = Mth.cos((float)(f7 + 1.5707964f)) * 0.2f;
        float f24 = Mth.sin((float)(f7 + 1.5707964f)) * 0.2f;
        float f25 = Mth.cos((float)(f7 + 4.712389f)) * 0.2f;
        float f26 = Mth.sin((float)(f7 + 4.712389f)) * 0.2f;
        float f29 = -1.0f + f2;
        float f30 = f4 * 2.5f + f29;
        VertexConsumer buffer = bufferIn.getBuffer(TEXTURE_BEAM);
        PoseStack.Pose entry = matrixStackIn.last();
        Matrix4f matrix4f = entry.pose();
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f19, f4, f20, j, k, l, 0.4999f, f30);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f21, 0.0f, f22, j, k, l, 0.0f, f29);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f21, f4, f22, j, k, l, 0.0f, f30);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f23, f4, f24, j, k, l, 0.4999f, f30);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f25, 0.0f, f26, j, k, l, 0.0f, f29);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f25, f4, f26, j, k, l, 0.0f, f30);
        float f31 = 0.0f;
        if (entityIn.tickCount % 2 == 0) {
            f31 = 0.5f;
        }
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f17, f4, f18, j, k, l, 1.0f, f31);
        CockatriceBeamRender.vertex(buffer, matrix4f, entry, f15, f4, f16, j, k, l, 0.5f, f31);
        matrixStackIn.popPose();
    }

    private static Vec3 getPosition(Entity LivingEntityIn, double p_177110_2_, float p_177110_4_) {
        double d0 = LivingEntityIn.xOld + (LivingEntityIn.getX() - LivingEntityIn.xOld) * (double)p_177110_4_;
        double d1 = p_177110_2_ + LivingEntityIn.yOld + (LivingEntityIn.getY() - LivingEntityIn.yOld) * (double)p_177110_4_;
        double d2 = LivingEntityIn.zOld + (LivingEntityIn.getZ() - LivingEntityIn.zOld) * (double)p_177110_4_;
        return new Vec3(d0, d1, d2);
    }
}

