/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.network;

import com.iafenvoy.iceandfire.entity.EntityAmphithere;
import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityHippocampus;
import com.iafenvoy.iceandfire.entity.EntityHippogryph;
import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.event.ServerEvents;
import com.iafenvoy.iceandfire.network.payload.DragonControlPayload;
import com.iafenvoy.iceandfire.network.payload.DragonSetBurnBlockPayload;
import com.iafenvoy.iceandfire.network.payload.MultipartInteractPayload;
import com.iafenvoy.iceandfire.network.payload.PlayerHitMultipartPayload;
import com.iafenvoy.iceandfire.network.payload.StartRidingMobC2SPayload;
import com.iafenvoy.iceandfire.network.payload.StartRidingMobS2CPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHousePayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieJarPayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePodiumPayload;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ServerNetworkHelper {
    public static void registerReceivers() {
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(DragonSetBurnBlockPayload.ID, DragonSetBurnBlockPayload.CODEC);
            NetworkManager.registerS2CPayloadType(StartRidingMobS2CPayload.ID, StartRidingMobS2CPayload.CODEC);
            NetworkManager.registerS2CPayloadType(UpdatePixieHousePayload.ID, UpdatePixieHousePayload.CODEC);
            NetworkManager.registerS2CPayloadType(UpdatePixieJarPayload.ID, UpdatePixieJarPayload.CODEC);
            NetworkManager.registerS2CPayloadType(UpdatePodiumPayload.ID, UpdatePodiumPayload.CODEC);
        }
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, DragonControlPayload.ID, DragonControlPayload.CODEC, (payload, ctx) -> {
            Entity entity;
            Player player = ctx.getPlayer();
            if (player != null && ServerEvents.isRidingOrBeingRiddenBy(entity = player.level().getEntity(payload.dragonId()), (Entity)player)) {
                BlockPos pos = payload.pos();
                Entity entity2 = entity;
                Objects.requireNonNull(entity2);
                Entity selector0$temp = entity2;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityDragonBase.class, EntityHippogryph.class, EntityHippocampus.class, EntityDeathWorm.class, EntityAmphithere.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        EntityDragonBase dragon = (EntityDragonBase)selector0$temp;
                        if (!dragon.isOwnedBy((LivingEntity)player)) break;
                        dragon.setControlState(payload.controlState());
                        break;
                    }
                    case 1: {
                        EntityHippogryph hippogryph = (EntityHippogryph)selector0$temp;
                        if (!hippogryph.isOwnedBy((LivingEntity)player)) break;
                        hippogryph.setControlState(payload.controlState());
                        break;
                    }
                    case 2: {
                        EntityHippocampus hippo = (EntityHippocampus)selector0$temp;
                        if (hippo.isOwnedBy((LivingEntity)player)) {
                            hippo.setControlState(payload.controlState());
                        }
                        hippo.setPosRaw(pos.getX(), pos.getY(), pos.getZ());
                        break;
                    }
                    case 3: {
                        EntityDeathWorm deathWorm = (EntityDeathWorm)selector0$temp;
                        deathWorm.setControlState(payload.controlState());
                        deathWorm.setPosRaw(pos.getX(), pos.getY(), pos.getZ());
                        break;
                    }
                    case 4: {
                        EntityAmphithere amphithere = (EntityAmphithere)selector0$temp;
                        if (amphithere.isOwnedBy((LivingEntity)player)) {
                            amphithere.setControlState(payload.controlState());
                        }
                        amphithere.setPosRaw(pos.getX(), pos.getY(), pos.getZ());
                        break;
                    }
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, MultipartInteractPayload.ID, MultipartInteractPayload.CODEC, (payload, ctx) -> {
            Player player = ctx.getPlayer();
            ctx.queue(() -> {
                LivingEntity livingEntity;
                double dist;
                ServerLevel serverWorld;
                Entity entity;
                Level patt0$temp;
                if (player != null && (patt0$temp = player.level()) instanceof ServerLevel && (entity = (serverWorld = (ServerLevel)patt0$temp).getEntity(payload.creatureID())) instanceof LivingEntity && (dist = (double)player.distanceTo((Entity)(livingEntity = (LivingEntity)entity))) < 100.0) {
                    float dmg = payload.dmg();
                    if (dmg > 0.0f) {
                        livingEntity.hurt(player.level().damageSources.mobAttack((LivingEntity)player), dmg);
                    } else {
                        livingEntity.interact(player, InteractionHand.MAIN_HAND);
                    }
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, PlayerHitMultipartPayload.ID, PlayerHitMultipartPayload.CODEC, (payload, ctx) -> {
            LivingEntity livingEntity;
            double dist;
            Entity entity;
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.level().getEntity(payload.entityId())) instanceof LivingEntity && (dist = (double)player.distanceTo((Entity)(livingEntity = (LivingEntity)entity))) < 100.0) {
                player.attack((Entity)livingEntity);
                if (livingEntity instanceof EntityHydra) {
                    EntityHydra hydra = (EntityHydra)livingEntity;
                    hydra.triggerHeadFlags(payload.index());
                }
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, StartRidingMobC2SPayload.ID, StartRidingMobC2SPayload.CODEC, (payload, ctx) -> {
            TamableAnimal tamable;
            Entity entity;
            Player player = ctx.getPlayer();
            if (player != null && (entity = player.level().getEntity(payload.dragonId())) instanceof ISyncMount && entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).isOwnedBy((LivingEntity)player) && tamable.distanceTo((Entity)player) < 14.0f) {
                if (payload.ride()) {
                    if (payload.baby()) {
                        tamable.startRiding((Entity)player, true);
                    } else {
                        player.startRiding((Entity)tamable, true);
                    }
                } else if (payload.baby()) {
                    tamable.stopRiding();
                } else {
                    player.stopRiding();
                }
            }
        });
    }
}

