/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.loot;

import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.item.ItemDragonEgg;
import com.iafenvoy.iceandfire.item.ItemDragonScales;
import com.iafenvoy.iceandfire.item.ItemDragonSkull;
import com.iafenvoy.iceandfire.item.food.ItemDragonFlesh;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafLoots;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CustomizeToDragon
extends LootItemConditionalFunction {
    public static final MapCodec<CustomizeToDragon> CODEC = RecordCodecBuilder.mapCodec(instance -> CustomizeToDragon.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CustomizeToDragon::new));

    public CustomizeToDragon(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Object object;
        if (!stack.isEmpty() && (object = context.getParamOrNull(LootContextParams.THIS_ENTITY)) instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)object;
            if (stack.getItem() == IafItems.DRAGON_BONE.get()) {
                stack.setCount(1 + dragon.getRandom().nextInt(1 + dragon.getAgeInDays() / 25));
                return stack;
            }
            if (stack.getItem() instanceof ItemDragonScales) {
                stack.setCount(dragon.getAgeInDays() / 25 + dragon.getRandom().nextInt(1 + dragon.getAgeInDays() / 5));
                return new ItemStack((ItemLike)DragonColor.getById(dragon.getVariant()).getScaleItem(), stack.getCount());
            }
            if (stack.getItem() instanceof ItemDragonEgg) {
                if (dragon.isMature()) {
                    return new ItemStack((ItemLike)DragonColor.getById(dragon.getVariant()).getEggItem(), stack.getCount());
                }
                stack.setCount(1 + dragon.getRandom().nextInt(1 + dragon.getAgeInDays() / 5));
                return new ItemStack((ItemLike)DragonColor.getById(dragon.getVariant()).getScaleItem(), stack.getCount());
            }
            if (stack.getItem() instanceof ItemDragonFlesh) {
                return new ItemStack((ItemLike)dragon.getFleshItem(), 1 + dragon.getRandom().nextInt(1 + dragon.getAgeInDays() / 25));
            }
            if (stack.getItem() instanceof ItemDragonSkull) {
                return stack.transmuteCopy((ItemLike)dragon.getSkull(), stack.getCount());
            }
            if (stack.is(IafItemTags.DRAGON_BLOODS)) {
                return new ItemStack((ItemLike)dragon.getBloodItem(), stack.getCount());
            }
            if (stack.is(IafItemTags.DRAGON_HEARTS)) {
                return new ItemStack(dragon.getHeartItem(), stack.getCount());
            }
        }
        return stack;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)IafLoots.CUSTOMIZE_TO_DRAGON.get();
    }
}

