/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockDragonForgeCore
extends BaseEntityBlock
implements IDragonProof {
    private final int isFire;

    public BlockDragonForgeCore(int isFire, boolean activated) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).dynamicShape().strength(40.0f, 500.0f).sound(SoundType.METAL).lightLevel(state -> activated ? 15 : 0));
        this.isFire = isFire;
    }

    public static String name(int dragonType, boolean activated) {
        return "dragonforge_%s_core%s".formatted(DragonType.getNameFromInt(dragonType), activated ? "" : "_disabled");
    }

    public static void setState(int dragonType, boolean active, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (active) {
            switch (dragonType) {
                case 0: {
                    worldIn.setBlock(pos, ((Block)IafBlocks.DRAGONFORGE_FIRE_CORE.get()).defaultBlockState(), 3);
                    break;
                }
                case 1: {
                    worldIn.setBlock(pos, ((Block)IafBlocks.DRAGONFORGE_ICE_CORE.get()).defaultBlockState(), 3);
                    break;
                }
                case 2: {
                    worldIn.setBlock(pos, ((Block)IafBlocks.DRAGONFORGE_LIGHTNING_CORE.get()).defaultBlockState(), 3);
                }
            }
        } else {
            switch (dragonType) {
                case 0: {
                    worldIn.setBlock(pos, ((Block)IafBlocks.DRAGONFORGE_FIRE_CORE_DISABLED.get()).defaultBlockState(), 3);
                    break;
                }
                case 1: {
                    worldIn.setBlock(pos, ((Block)IafBlocks.DRAGONFORGE_ICE_CORE_DISABLED.get()).defaultBlockState(), 3);
                    break;
                }
                case 2: {
                    worldIn.setBlock(pos, ((Block)IafBlocks.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get()).defaultBlockState(), 3);
                }
            }
        }
        if (blockEntity != null) {
            blockEntity.clearRemoved();
            worldIn.setBlockEntity(blockEntity);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isShiftKeyDown()) {
            MenuProvider screenHandlerFactory;
            if (!world.isClientSide && (screenHandlerFactory = this.getMenuProvider(state, world, pos)) != null) {
                player.openMenu(screenHandlerFactory);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public ItemStack getItem(Level world, BlockPos pos, BlockState state) {
        return switch (this.isFire) {
            case 1 -> new ItemStack((ItemLike)((Block)IafBlocks.DRAGONFORGE_ICE_CORE_DISABLED.get()).asItem());
            case 2 -> new ItemStack((ItemLike)((Block)IafBlocks.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get()).asItem());
            default -> new ItemStack((ItemLike)((Block)IafBlocks.DRAGONFORGE_FIRE_CORE_DISABLED.get()).asItem());
        };
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BlockEntityDragonForge) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)((BlockEntityDragonForge)blockEntity));
            world.updateNeighbourForOutputSignal(pos, (Block)this);
            world.removeBlockEntity(pos);
        }
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> entityType) {
        return BlockDragonForgeCore.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.DRAGONFORGE_CORE.get()), BlockEntityDragonForge::tick);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityDragonForge(pos, state, this.isFire);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return MapCodec.unit((Object)this);
    }
}

