/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.armor;

import com.iafenvoy.iceandfire.data.TrollType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ItemTrollArmor
extends ArmorItem {
    public final TrollType troll;

    public ItemTrollArmor(TrollType troll, ArmorItem.Type slot) {
        Holder<ArmorMaterial> holder = troll.getMaterial();
        Item.Properties properties = new Item.Properties();
        super(holder, slot, properties.durability(switch (slot) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.HELMET -> 220;
            case ArmorItem.Type.CHESTPLATE -> 320;
            case ArmorItem.Type.LEGGINGS -> 300;
            case ArmorItem.Type.BOOTS -> 260;
            case ArmorItem.Type.BODY -> 0;
        }));
        this.troll = troll;
    }

    public static String getName(TrollType troll, EquipmentSlot slot) {
        return "%s_troll_leather_%s".formatted(troll.getName(), ItemTrollArmor.getArmorPart(slot));
    }

    private static String getArmorPart(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> "helmet";
            case EquipmentSlot.CHEST -> "chestplate";
            case EquipmentSlot.LEGS -> "leggings";
            case EquipmentSlot.FEET -> "boots";
            default -> "";
        };
    }

    public Holder<ArmorMaterial> getMaterial() {
        return this.troll.getMaterial();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)("item.iceandfire.troll_leather_armor_" + ItemTrollArmor.getArmorPart(this.type.getSlot()) + ".desc")).withStyle(ChatFormatting.GREEN));
    }
}

