/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.armor;

import com.iafenvoy.iceandfire.data.DragonArmor;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.item.armor.IProtectAgainstDragonItem;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ItemScaleArmor
extends ArmorItem
implements IProtectAgainstDragonItem {
    public final DragonArmor armorType;
    public final DragonColor eggType;

    public ItemScaleArmor(DragonColor eggType, DragonArmor armorType, Holder<ArmorMaterial> material, ArmorItem.Type slot) {
        Item.Properties properties = new Item.Properties();
        super(material, slot, properties.durability(switch (slot) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.HELMET -> 397;
            case ArmorItem.Type.CHESTPLATE -> 577;
            case ArmorItem.Type.LEGGINGS -> 541;
            case ArmorItem.Type.BOOTS -> 469;
            case ArmorItem.Type.BODY -> 0;
        }));
        this.armorType = armorType;
        this.eggType = eggType;
    }

    public String getDescriptionId() {
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.HELMET -> "item.iceandfire.dragon_helmet";
            case ArmorItem.Type.CHESTPLATE -> "item.iceandfire.dragon_chestplate";
            case ArmorItem.Type.LEGGINGS -> "item.iceandfire.dragon_leggings";
            case ArmorItem.Type.BOOTS -> "item.iceandfire.dragon_boots";
            case ArmorItem.Type.BODY -> "???";
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)("dragon." + this.eggType.name().toLowerCase(Locale.ROOT))).withStyle(this.eggType.color()));
        tooltip.add((Component)Component.translatable((String)"item.dragonscales_armor.desc").withStyle(ChatFormatting.GRAY));
    }
}

