/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.component.StoneStatusComponent;
import com.iafenvoy.iceandfire.entity.EntityStoneStatue;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;

public class ItemStoneStatue
extends Item {
    public ItemStoneStatue() {
        super(new Item.Properties().stacksTo(1).component((DataComponentType)IafDataComponents.STONE_STATUS.get(), (Object)new StoneStatusComponent(true, "", new CompoundTag())));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        StoneStatusComponent component;
        Optional optional;
        super.appendHoverText(stack, context, tooltip, type);
        if (stack.has((DataComponentType)IafDataComponents.STONE_STATUS.get()) && (optional = EntityType.byString((String)(component = (StoneStatusComponent)stack.get((DataComponentType)IafDataComponents.STONE_STATUS.get())).entityType())).isPresent()) {
            MutableComponent untranslated = component.isPlayer() ? Component.translatable((String)"entity.minecraft.player") : Component.translatable((String)((EntityType)optional.get()).getDescriptionId());
            tooltip.add((Component)untranslated.withStyle(ChatFormatting.GRAY));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getClickedFace() != Direction.UP) {
            return InteractionResult.FAIL;
        }
        assert (context.getPlayer() != null);
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        if (stack.has((DataComponentType)IafDataComponents.STONE_STATUS.get())) {
            float yaw;
            StoneStatusComponent component = (StoneStatusComponent)stack.get((DataComponentType)IafDataComponents.STONE_STATUS.get());
            EntityStoneStatue statue = new EntityStoneStatue((EntityType<? extends LivingEntity>)((EntityType)IafEntities.STONE_STATUE.get()), context.getLevel());
            statue.readAdditionalSaveData(component.nbt());
            statue.setTrappedEntityTypeString(component.entityType());
            double d1 = context.getPlayer().getX() - ((double)context.getClickedPos().getX() + 0.5);
            double d2 = context.getPlayer().getZ() - ((double)context.getClickedPos().getZ() + 0.5);
            statue.yRotO = yaw = (float)(Mth.atan2((double)d2, (double)d1) * 57.2957763671875) - 90.0f;
            statue.setYRot(yaw);
            statue.yHeadRot = yaw;
            statue.yBodyRot = yaw;
            statue.yBodyRotO = yaw;
            statue.absMoveTo((double)context.getClickedPos().getX() + 0.5, context.getClickedPos().getY() + 1, (double)context.getClickedPos().getZ() + 0.5, yaw, 0.0f);
            if (!context.getLevel().isClientSide) {
                context.getLevel().addFreshEntity((Entity)statue);
            }
            statue.setCrackAmount(0);
            if (!context.getPlayer().isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }
}

