/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemDragonSeeker
extends Item {
    private final SeekerType type;

    public ItemDragonSeeker(SeekerType type) {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.RARE));
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (world.isClientSide) {
            return super.use(world, user, hand);
        }
        if (!((Boolean)IafCommonConfig.INSTANCE.misc.enableDragonSeeker.getValue()).booleanValue()) {
            user.displayClientMessage((Component)Component.translatable((String)"text.iceandfire.not_enable"), false);
            return super.use(world, user, hand);
        }
        ItemStack stack = user.getItemInHand(hand);
        EntityDragonBase dragon = (EntityDragonBase)world.getNearestEntity(EntityDragonBase.class, TargetingConditions.forCombat().selector(entity -> {
            if (!(entity instanceof EntityDragonBase)) {
                return false;
            }
            EntityDragonBase d = (EntityDragonBase)entity;
            if (d.isMobDead() && !this.type.trackDead) {
                return false;
            }
            return !d.isTame() || this.type.trackTeamed;
        }), (LivingEntity)user, user.getX(), user.getY(), user.getZ(), new AABB(this.type.add(user.position(), true), this.type.add(user.position(), false)));
        if (dragon == null) {
            user.sendSystemMessage((Component)Component.translatable((String)"item.iceandfire.dragon_seeker.not_found"));
            return InteractionResultHolder.fail((Object)stack);
        }
        if (this.type.admin) {
            String pos1 = String.format("[%d, %d, %d]", (int)dragon.getX(), (int)dragon.getY(), (int)dragon.getZ());
            String pos2 = String.format("/tp @s %d %d %d", (int)dragon.getX(), (int)dragon.getY(), (int)dragon.getZ());
            MutableComponent locationText = Component.literal((String)pos1).setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, pos2)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"))));
            user.sendSystemMessage((Component)Component.translatable((String)"item.iceandfire.dragon_seeker.found_location").append((Component)locationText));
        } else {
            user.sendSystemMessage((Component)Component.translatable((String)"item.iceandfire.dragon_seeker.found"));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        String name = BuiltInRegistries.ITEM.getKey((Object)this).getPath();
        tooltip.add((Component)Component.translatable((String)("item.iceandfire." + name + ".tooltip")));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.dragon_seeker.credit").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true))));
    }

    public static enum SeekerType {
        NORMAL(150, true, true, false),
        EPIC(200, false, true, false),
        LEGENDARY(300, false, false, false),
        GODLY(500, false, false, true);

        private final int trackRange;
        private final boolean trackDead;
        private final boolean trackTeamed;
        private final boolean admin;

        private SeekerType(int trackRange, boolean trackDead, boolean trackTeamed, boolean admin) {
            this.trackRange = trackRange;
            this.trackDead = trackDead;
            this.trackTeamed = trackTeamed;
            this.admin = admin;
        }

        public Vec3 add(Vec3 origin, boolean reverse) {
            int range = this.trackRange;
            if (reverse) {
                range *= -1;
            }
            return origin.add((double)range, (double)range, (double)range);
        }
    }
}

