/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.item.block.BlockDragonForgeInput;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockEntityDragonForgeInput
extends BlockEntity {
    private static final int LURE_DISTANCE = 50;
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private int ticksSinceDragonFire;
    private BlockEntityDragonForge core = null;

    public BlockEntityDragonForgeInput(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.DRAGONFORGE_INPUT.get(), pos, state);
    }

    public static void tick(Level level, BlockPos position, BlockState state, BlockEntityDragonForgeInput forgeInput) {
        if (forgeInput.core == null) {
            forgeInput.core = forgeInput.getConnectedTileEntity(position);
        }
        if (forgeInput.ticksSinceDragonFire > 0) {
            --forgeInput.ticksSinceDragonFire;
        }
        if ((forgeInput.ticksSinceDragonFire == 0 || forgeInput.core == null) && forgeInput.isActive()) {
            BlockEntity tileentity = level.getBlockEntity(position);
            level.setBlockAndUpdate(position, forgeInput.getDeactivatedState());
            if (tileentity != null) {
                tileentity.clearRemoved();
                level.setBlockEntity(tileentity);
            }
        }
        if (forgeInput.isAssembled()) {
            forgeInput.lureDragons();
        }
    }

    public void onHitWithFlame() {
        if (this.core != null) {
            this.core.transferPower(1);
        }
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithFullMetadata(registryLookup);
    }

    protected void lureDragons() {
        Vec3 targetPosition = new Vec3((double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 0.5f), (double)((float)this.getBlockPos().getZ() + 0.5f));
        AABB searchArea = new AABB((double)this.worldPosition.getX() - 50.0, (double)this.worldPosition.getY() - 50.0, (double)this.worldPosition.getZ() - 50.0, (double)this.worldPosition.getX() + 50.0, (double)this.worldPosition.getY() + 50.0, (double)this.worldPosition.getZ() + 50.0);
        boolean dragonSelected = false;
        assert (this.level != null);
        for (EntityDragonBase dragon : this.level.getEntitiesOfClass(EntityDragonBase.class, searchArea)) {
            if (!dragonSelected && this.getDragonType() == dragon.dragonType.getIntFromType() && (dragon.isChained() || dragon.isTame()) && this.canSeeInput(dragon, targetPosition)) {
                dragon.burningTarget = this.worldPosition;
                dragonSelected = true;
                continue;
            }
            if (dragon.burningTarget != this.worldPosition) continue;
            dragon.burningTarget = null;
            dragon.setBreathingFire(false);
        }
    }

    public boolean isAssembled() {
        return this.core != null && this.core.assembled() && this.core.canSmelt();
    }

    private boolean canSeeInput(EntityDragonBase dragon, Vec3 target) {
        if (target != null) {
            assert (this.level != null);
            BlockHitResult rayTrace = this.level.clip(new ClipContext(dragon.getHeadPosition(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dragon));
            double distance = dragon.getHeadPosition().distanceTo(rayTrace.getLocation());
            return distance < (double)(10.0f + dragon.getBbWidth() * 2.0f);
        }
        return false;
    }

    private BlockState getDeactivatedState() {
        return switch (this.getDragonType()) {
            case 1 -> (BlockState)((Block)IafBlocks.DRAGONFORGE_ICE_INPUT.get()).defaultBlockState().setValue((Property)BlockDragonForgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            case 2 -> (BlockState)((Block)IafBlocks.DRAGONFORGE_LIGHTNING_INPUT.get()).defaultBlockState().setValue((Property)BlockDragonForgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            default -> (BlockState)((Block)IafBlocks.DRAGONFORGE_FIRE_INPUT.get()).defaultBlockState().setValue((Property)BlockDragonForgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
        };
    }

    private int getDragonType() {
        assert (this.level != null);
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (state.getBlock() == IafBlocks.DRAGONFORGE_FIRE_INPUT.get()) {
            return 0;
        }
        if (state.getBlock() == IafBlocks.DRAGONFORGE_ICE_INPUT.get()) {
            return 1;
        }
        if (state.getBlock() == IafBlocks.DRAGONFORGE_LIGHTNING_INPUT.get()) {
            return 2;
        }
        return 0;
    }

    private boolean isActive() {
        assert (this.level != null);
        BlockState state = this.level.getBlockState(this.worldPosition);
        return state.getBlock() instanceof BlockDragonForgeInput && (Boolean)state.getValue((Property)BlockDragonForgeInput.ACTIVE) != false;
    }

    private BlockEntityDragonForge getConnectedTileEntity(BlockPos position) {
        for (Direction facing : HORIZONTALS) {
            assert (this.level != null);
            BlockEntity blockEntity = this.level.getBlockEntity(position.relative(facing));
            if (!(blockEntity instanceof BlockEntityDragonForge)) continue;
            BlockEntityDragonForge forge = (BlockEntityDragonForge)blockEntity;
            return forge;
        }
        return null;
    }
}

