/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.util.IafMath;
import com.iafenvoy.uranus.object.item.FoodUtils;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class DragonAITargetItems
extends TargetGoal {
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    private final int targetChance;
    private final boolean prioritizeItems;
    private final boolean isIce;
    protected ItemEntity targetEntity;
    private List<ItemEntity> list = IafMath.emptyItemEntityList;

    public DragonAITargetItems(EntityDragonBase creature, boolean checkSight) {
        this(creature, 20, checkSight, false, false);
    }

    public DragonAITargetItems(EntityDragonBase creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 20, checkSight, onlyNearby, false);
    }

    public DragonAITargetItems(EntityDragonBase creature, int chance, boolean checkSight, boolean onlyNearby) {
        this(creature, chance, checkSight, onlyNearby, false);
    }

    public DragonAITargetItems(EntityDragonBase creature, int chance, boolean checkSight, boolean onlyNearby, boolean prioritizeItems) {
        super((Mob)creature, checkSight, onlyNearby);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.isIce = creature instanceof EntityIceDragon;
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.targetEntitySelector = item -> item != null && !item.getItem().isEmpty() && FoodUtils.getFoodPoints((ItemStack)item.getItem(), (boolean)true, (boolean)this.isIce) > 0;
        this.prioritizeItems = prioritizeItems;
    }

    public boolean canUse() {
        EntityDragonBase dragon = (EntityDragonBase)this.mob;
        if (this.prioritizeItems && dragon.getHunger() >= 60) {
            return false;
        }
        if (dragon.getHunger() >= 100 || !dragon.canMove() || this.targetChance > 0 && this.mob.getRandom().nextInt(10) != 0) {
            this.list = IafMath.emptyItemEntityList;
            return false;
        }
        return this.updateList();
    }

    private boolean updateList() {
        if (this.mob.level().getGameTime() % 4L == 0L) {
            this.list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.getTargetableArea(this.getFollowDistance()), this.targetEntitySelector);
        }
        if (this.list.isEmpty()) {
            return false;
        }
        this.list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = this.list.getFirst();
        return true;
    }

    protected AABB getTargetableArea(double targetDistance) {
        return this.mob.getBoundingBox().inflate(targetDistance, 4.0, targetDistance);
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.targetEntity.getX(), this.targetEntity.getY(), this.targetEntity.getZ(), 1.0);
        super.start();
    }

    public void tick() {
        EntityDragonBase dragon;
        Mob mob;
        super.tick();
        ItemStack stack = this.targetEntity.getItem();
        if (this.targetEntity == null || !this.targetEntity.isAlive() || stack.isEmpty()) {
            this.stop();
        } else if (this.mob.distanceToSqr((Entity)this.targetEntity) < (double)(this.mob.getBbWidth() * 2.0f + this.mob.getBbHeight() / 2.0f) || (mob = this.mob) instanceof EntityDragonBase && (dragon = (EntityDragonBase)mob).getHeadPosition().distanceToSqr(this.targetEntity.position()) < (double)this.mob.getBbHeight()) {
            this.mob.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
            int hunger = FoodUtils.getFoodPoints((ItemStack)this.targetEntity.getItem(), (boolean)true, (boolean)this.isIce);
            EntityDragonBase dragon2 = (EntityDragonBase)this.mob;
            dragon2.setHunger(Math.min(100, dragon2.getHunger() + hunger));
            this.targetEntity.getItem();
            this.mob.setHealth(Math.min(this.mob.getMaxHealth(), (float)((int)(this.mob.getHealth() + (float)FoodUtils.getFoodPoints((ItemStack)this.targetEntity.getItem(), (boolean)true, (boolean)this.isIce)))));
            if (EntityDragonBase.ANIMATION_EAT != null) {
                dragon2.setAnimation(EntityDragonBase.ANIMATION_EAT);
            }
            for (int i = 0; i < 4; ++i) {
                dragon2.spawnItemCrackParticles(stack.getItem());
            }
            this.targetEntity.getItem().shrink(1);
            this.stop();
        } else {
            this.updateList();
        }
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d0 = this.theEntity.distanceToSqr(p_compare_1_);
            double d1 = this.theEntity.distanceToSqr(p_compare_2_);
            return Double.compare(d0, d1);
        }
    }
}

