/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.TrollType;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.EntityStoneStatue;
import com.iafenvoy.iceandfire.entity.ai.TrollAIFleeSun;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IHumanoid;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootTable;

public class EntityTroll
extends Monster
implements IAnimatedEntity,
IVillagerFear,
IHumanoid,
IHasCustomizableAttributes {
    public static final Animation ANIMATION_STRIKE_HORIZONTAL = Animation.create((int)20);
    public static final Animation ANIMATION_STRIKE_VERTICAL = Animation.create((int)20);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    public static final Animation ANIMATION_ROAR = Animation.create((int)25);
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(EntityTroll.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> WEAPON = SynchedEntityData.defineId(EntityTroll.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public float stoneProgress;
    private int animationTick;
    private Animation currentAnimation;
    private boolean avoidSun = true;

    public EntityTroll(EntityType<EntityTroll> t, Level worldIn) {
        super(t, worldIn);
    }

    public static boolean canTrollSpawnOn(EntityType<? extends Mob> typeIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.getDifficulty() != Difficulty.PEACEFUL && GenerationConstants.isFarEnoughFromSpawn(pos) && EntityTroll.isDarkEnoughToSpawn((ServerLevelAccessor)worldIn, (BlockPos)pos, (RandomSource)randomIn) && EntityTroll.checkMobSpawnRules((EntityType)((EntityType)IafEntities.TROLL.get()), (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ((Double)IafCommonConfig.INSTANCE.troll.maxHealth.getValue()).doubleValue()).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, ((Double)IafCommonConfig.INSTANCE.troll.attackDamage.getValue()).doubleValue()).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ARMOR, 9.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)IafCommonConfig.INSTANCE.troll.maxHealth.getValue()).doubleValue());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(((Double)IafCommonConfig.INSTANCE.troll.attackDamage.getValue()).doubleValue());
    }

    private void setAvoidSun(boolean day) {
        if (day && !this.avoidSun) {
            ((GroundPathNavigation)this.getNavigation()).setAvoidSun(true);
            this.avoidSun = true;
        }
        if (!day && this.avoidSun) {
            ((GroundPathNavigation)this.getNavigation()).setAvoidSun(false);
            this.avoidSun = false;
        }
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        return worldIn.isUnobstructed((Entity)this);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        BlockPos pos = this.blockPosition();
        BlockPos heightAt = worldIn.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
        boolean rngCheck = true;
        return pos.getY() < heightAt.getY() - 10 && super.checkSpawnRules(worldIn, spawnReasonIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new TrollAIFleeSun(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 1.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.setAvoidSun(true);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.getRandom().nextBoolean()) {
            this.setAnimation(ANIMATION_STRIKE_VERTICAL);
        } else {
            this.setAnimation(ANIMATION_STRIKE_HORIZONTAL);
        }
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)TrollType.FOREST.getName());
        builder.define(WEAPON, (Object)TrollType.BuiltinWeapon.AXE.getName());
    }

    private String getVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    private void setVariant(String variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public TrollType getTrollType() {
        return TrollType.getByName(this.getVariant());
    }

    public void setTrollType(TrollType variant) {
        this.setVariant(variant.getName());
    }

    private String getWeapon() {
        return (String)this.entityData.get(WEAPON);
    }

    private void setWeapon(String variant) {
        this.entityData.set(WEAPON, (Object)variant);
    }

    public TrollType.ITrollWeapon getWeaponType() {
        return TrollType.ITrollWeapon.getByName(this.getWeapon());
    }

    public void setWeaponType(TrollType.ITrollWeapon variant) {
        this.setWeapon(variant.getName());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Variant", this.getVariant());
        compound.putString("Weapon", this.getWeapon());
        compound.putFloat("StoneProgress", this.stoneProgress);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getString("Variant"));
        this.setWeapon(compound.getString("Weapon"));
        this.stoneProgress = compound.getFloat("StoneProgress");
        this.setConfigurableAttributes();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        spawnDataIn = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setTrollType(TrollType.getBiomeType((Holder<Biome>)this.level().getBiome(this.blockPosition())));
        this.setWeaponType(TrollType.getWeaponForType(this.getTrollType()));
        return spawnDataIn;
    }

    public boolean hurt(DamageSource source, float damage) {
        if (source.getMsgId().contains("arrow")) {
            return false;
        }
        return super.hurt(source, damage);
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.getTrollType().getLootTable());
    }

    public int getBaseExperienceReward() {
        return 15;
    }

    protected void tickDeath() {
        super.tickDeath();
        if (this.deathTime == 20 && !this.level().isClientSide && ((Boolean)IafCommonConfig.INSTANCE.troll.dropWeapon.getValue()).booleanValue()) {
            if (this.getRandom().nextInt(3) == 0) {
                ItemStack weaponStack = new ItemStack((ItemLike)this.getWeaponType().getItem(), 1);
                weaponStack.setDamageValue(this.getRandom().nextInt(250));
                this.dropItemAt(weaponStack, this.getX(), this.getY(), this.getZ());
            } else {
                ItemStack brokenDrop = new ItemStack((ItemLike)Blocks.STONE_BRICKS, this.getRandom().nextInt(2) + 1);
                ItemStack brokenDrop2 = new ItemStack((ItemLike)Blocks.STONE_BRICKS, this.getRandom().nextInt(2) + 1);
                if (this.getWeaponType() == TrollType.BuiltinWeapon.AXE) {
                    brokenDrop = new ItemStack((ItemLike)Items.STICK, this.getRandom().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.COBBLESTONE, this.getRandom().nextInt(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.COLUMN) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.STONE_BRICKS, this.getRandom().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.STONE_BRICKS, this.getRandom().nextInt(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.COLUMN_FOREST) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.STONE_BRICKS, this.getRandom().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.STONE_BRICKS, this.getRandom().nextInt(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.COLUMN_FROST) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.STONE_BRICKS, this.getRandom().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Items.SNOWBALL, this.getRandom().nextInt(4) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.HAMMER) {
                    brokenDrop = new ItemStack((ItemLike)Items.BONE, this.getRandom().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.COBBLESTONE, this.getRandom().nextInt(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.TRUNK) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.OAK_LOG, this.getRandom().nextInt(2) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Blocks.OAK_LOG, this.getRandom().nextInt(2) + 1);
                }
                if (this.getWeaponType() == TrollType.BuiltinWeapon.TRUNK_FROST) {
                    brokenDrop = new ItemStack((ItemLike)Blocks.SPRUCE_LOG, this.getRandom().nextInt(4) + 1);
                    brokenDrop2 = new ItemStack((ItemLike)Items.SNOWBALL, this.getRandom().nextInt(4) + 1);
                }
                this.dropItemAt(brokenDrop, this.getX(), this.getY(), this.getZ());
                this.dropItemAt(brokenDrop2, this.getX(), this.getY(), this.getZ());
            }
        }
    }

    private void dropItemAt(ItemStack stack, double x, double y, double z) {
        if (stack.getCount() > 0) {
            ItemEntity entityitem = new ItemEntity(this.level(), x, y, z, stack);
            entityitem.setDefaultPickUpDelay();
            this.level().addFreshEntity((Entity)entityitem);
        }
    }

    public void aiStep() {
        boolean stone;
        super.aiStep();
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.getTarget() instanceof Player) {
            this.setTarget(null);
        }
        if ((stone = EntityGorgon.isStoneMob((LivingEntity)this)) && this.stoneProgress < 20.0f) {
            this.stoneProgress += 2.0f;
        } else if (!stone && this.stoneProgress > 0.0f) {
            this.stoneProgress -= 2.0f;
        }
        if (!stone && this.getAnimation() == NO_ANIMATION && this.getTarget() != null && this.getRandom().nextInt(100) == 0) {
            this.setAnimation(ANIMATION_ROAR);
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 5) {
            this.playSound((SoundEvent)IafSounds.TROLL_ROAR.get(), 1.0f, 1.0f);
        }
        if (!stone && this.getHealth() < this.getMaxHealth() && this.tickCount % 30 == 0) {
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 30, 1, false, false));
        }
        this.setAvoidSun(this.level().isDay());
        if (this.level().isDay() && !this.level().isClientSide) {
            BlockPos blockpos;
            float f = this.level().getBrightness(LightLayer.SKY, this.blockPosition());
            BlockPos blockPos = blockpos = this.getVehicle() instanceof Boat ? new BlockPos(this.getBlockX(), this.getBlockY(), this.getBlockZ()).above() : new BlockPos(this.getBlockX(), this.getBlockY(), this.getBlockZ());
            if (f > 0.5f && this.level().canSeeSky(blockpos)) {
                this.setDeltaMovement(0.0, 0.0, 0.0);
                this.setAnimation(NO_ANIMATION);
                this.playSound((SoundEvent)IafSounds.TURN_STONE.get(), 1.0f, 1.0f);
                this.stoneProgress = 20.0f;
                EntityStoneStatue statue = EntityStoneStatue.buildStatueEntity((LivingEntity)this);
                statue.getTrappedTag().putFloat("StoneProgress", 20.0f);
                statue.absMoveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
                if (!this.level().isClientSide) {
                    this.level().addFreshEntity((Entity)statue);
                }
                statue.yRotO = this.getYRot();
                statue.setYRot(this.getYRot());
                statue.yHeadRot = this.getYRot();
                statue.yBodyRot = this.getYRot();
                statue.yBodyRotO = this.getYRot();
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            float weaponX = (float)(this.getX() + (double)(1.9f * Mth.cos((float)((float)((double)(this.yBodyRot + 90.0f) * Math.PI / 180.0)))));
            float weaponZ = (float)(this.getZ() + (double)(1.9f * Mth.sin((float)((float)((double)(this.yBodyRot + 90.0f) * Math.PI / 180.0)))));
            float weaponY = (float)(this.getY() + (double)0.2f);
            BlockState state = this.level().getBlockState(BlockPos.containing((double)weaponX, (double)(weaponY - 1.0f), (double)weaponZ));
            for (int i = 0; i < 20; ++i) {
                double motionX = this.getRandom().nextGaussian() * 0.07;
                double motionY = this.getRandom().nextGaussian() * 0.07;
                double motionZ = this.getRandom().nextGaussian() * 0.07;
                if (!state.isSolid() || !this.level().isClientSide) continue;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)(weaponX + (this.getRandom().nextFloat() - 0.5f)), (double)(weaponY + (this.getRandom().nextFloat() - 0.5f)), (double)(weaponZ + (this.getRandom().nextFloat() - 0.5f)), motionX, motionY, motionZ);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) < 4.0 && this.getAnimationTick() == 10 && this.deathTime <= 0) {
            this.getTarget().hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) < 4.0 && this.getAnimationTick() == 10 && this.deathTime <= 0) {
            LivingEntity target = this.getTarget();
            target.hurt(this.level().damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
            float f5 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
            float f6 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
            target.setDeltaMovement((double)f5, (double)f6, (double)0.4f);
        }
        if (this.getNavigation().isDone() && this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > 3.0 && this.distanceToSqr((Entity)this.getTarget()) < 30.0 && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            this.lookAt((Entity)this.getTarget(), 30.0f, 30.0f);
            if (this.getAnimation() == NO_ANIMATION && this.random.nextInt(15) == 0) {
                this.setAnimation(ANIMATION_STRIKE_VERTICAL);
            }
            if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
                float weaponX = (float)(this.getX() + (double)(1.9f * Mth.cos((float)((float)((double)(this.yBodyRot + 90.0f) * Math.PI / 180.0)))));
                float weaponZ = (float)(this.getZ() + (double)(1.9f * Mth.sin((float)((float)((double)(this.yBodyRot + 90.0f) * Math.PI / 180.0)))));
                float weaponY = (float)(this.getY() + (double)(this.getEyeHeight() / 2.0f));
                Explosion explosion = new Explosion(this.level(), (Entity)this, (double)weaponX, (double)weaponY, (double)weaponZ, 1.0f + this.getRandom().nextFloat(), false, Explosion.BlockInteraction.KEEP);
                if (!((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((LivingEntity)this, weaponX, weaponY, weaponZ)) {
                    explosion.explode();
                    explosion.finalizeExplosion(true);
                }
                this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, 1.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            this.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 2.5f, 0.5f);
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.getAnimationTick() == 10) {
            this.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 2.5f, 0.5f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void playAmbientSound() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.playAmbientSound();
    }

    protected void playHurtSound(DamageSource source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.playHurtSound(source);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)IafSounds.TROLL_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)IafSounds.TROLL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)IafSounds.TROLL_DIE.get();
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_STRIKE_HORIZONTAL, ANIMATION_STRIKE_VERTICAL, ANIMATION_SPEAK, ANIMATION_ROAR};
    }
}

