/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.registry.tag.IafBiomeTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class HippogryphTypes {
    private static final List<HippogryphTypes> TYPES = new ArrayList<HippogryphTypes>();
    private static final Map<String, HippogryphTypes> BY_NAME = new HashMap<String, HippogryphTypes>();
    public static final HippogryphTypes BLACK = new HippogryphTypes("black", false, biome -> biome.is(IafBiomeTags.HIPPOGRYPH_BLACK));
    public static final HippogryphTypes BROWN = new HippogryphTypes("brown", false, biome -> biome.is(IafBiomeTags.HIPPOGRYPH_BROWN));
    public static final HippogryphTypes GRAY = new HippogryphTypes("gray", false, biome -> biome.is(IafBiomeTags.HIPPOGRYPH_GRAY));
    public static final HippogryphTypes CHESTNUT = new HippogryphTypes("chestnut", false, biome -> biome.is(IafBiomeTags.HIPPOGRYPH_CHESTNUT));
    public static final HippogryphTypes CREAMY = new HippogryphTypes("creamy", false, biome -> biome.is(IafBiomeTags.HIPPOGRYPH_CREAMY));
    public static final HippogryphTypes DARK_BROWN = new HippogryphTypes("dark_brown", false, biome -> biome.is(IafBiomeTags.HIPPOGRYPH_DARK_BROWN));
    public static final HippogryphTypes WHITE = new HippogryphTypes("white", false, biome -> biome.is(IafBiomeTags.HIPPOGRYPH_WHITE));
    public static final HippogryphTypes RAPTOR = new HippogryphTypes("raptor", true, biome -> false);
    public static final HippogryphTypes ALEX = new HippogryphTypes("alex", true, biome -> false);
    public static final HippogryphTypes DODO = new HippogryphTypes("dodo", true, biome -> false);
    public final boolean developer;
    private final String name;
    private final Predicate<Holder<Biome>> biomePredicate;

    public HippogryphTypes(String name, boolean developer, Predicate<Holder<Biome>> biomePredicate) {
        this.name = name;
        this.developer = developer;
        this.biomePredicate = biomePredicate;
        TYPES.add(this);
        BY_NAME.put(name, this);
    }

    public static List<HippogryphTypes> values() {
        return ImmutableList.copyOf(TYPES);
    }

    public static HippogryphTypes getByName(String name) {
        return BY_NAME.getOrDefault(name, BLACK);
    }

    public static HippogryphTypes[] getWildTypes() {
        return new HippogryphTypes[]{BLACK, BROWN, GRAY, CHESTNUT, CREAMY, DARK_BROWN, WHITE};
    }

    public static HippogryphTypes getRandomType() {
        return HippogryphTypes.getWildTypes()[ThreadLocalRandom.current().nextInt(HippogryphTypes.getWildTypes().length - 1)];
    }

    public static HippogryphTypes getBiomeType(Holder<Biome> biome) {
        List<HippogryphTypes> types = HippogryphTypes.values().stream().filter(x -> x.allowSpawn(biome)).toList();
        if (types.isEmpty()) {
            return HippogryphTypes.getRandomType();
        }
        if (types.contains(GRAY) && types.contains(CHESTNUT)) {
            return GRAY;
        }
        return types.get(ThreadLocalRandom.current().nextInt(types.size()));
    }

    public String getName() {
        return this.name;
    }

    public boolean allowSpawn(Holder<Biome> biome) {
        return this.biomePredicate.test(biome);
    }

    public ResourceLocation getTexture(boolean blink) {
        return ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)("textures/entity/hippogryph/" + this.name.toLowerCase(Locale.ROOT) + (blink ? "_blink" : "") + ".png"));
    }
}

