/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.item.armor.ItemScaleArmor;
import com.iafenvoy.iceandfire.registry.IafArmorMaterials;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class DragonArmor {
    private static final List<DragonArmor> ARMORS = new ArrayList<DragonArmor>();
    public static final DragonArmor RED = new DragonArmor(DragonColor.RED, (Supplier<Item>)IafItems.DRAGONSCALES_RED);
    public static final DragonArmor BRONZE = new DragonArmor(DragonColor.BRONZE, (Supplier<Item>)IafItems.DRAGONSCALES_BRONZE);
    public static final DragonArmor GREEN = new DragonArmor(DragonColor.GREEN, (Supplier<Item>)IafItems.DRAGONSCALES_GREEN);
    public static final DragonArmor GRAY = new DragonArmor(DragonColor.GRAY, (Supplier<Item>)IafItems.DRAGONSCALES_GRAY);
    public static final DragonArmor BLUE = new DragonArmor(DragonColor.BLUE, (Supplier<Item>)IafItems.DRAGONSCALES_BLUE);
    public static final DragonArmor WHITE = new DragonArmor(DragonColor.WHITE, (Supplier<Item>)IafItems.DRAGONSCALES_WHITE);
    public static final DragonArmor SAPPHIRE = new DragonArmor(DragonColor.SAPPHIRE, (Supplier<Item>)IafItems.DRAGONSCALES_SAPPHIRE);
    public static final DragonArmor SILVER = new DragonArmor(DragonColor.SILVER, (Supplier<Item>)IafItems.DRAGONSCALES_SILVER);
    public static final DragonArmor ELECTRIC = new DragonArmor(DragonColor.ELECTRIC, (Supplier<Item>)IafItems.DRAGONSCALES_ELECTRIC);
    public static final DragonArmor AMETHYST = new DragonArmor(DragonColor.AMETHYST, (Supplier<Item>)IafItems.DRAGONSCALES_AMETHYST);
    public static final DragonArmor COPPER = new DragonArmor(DragonColor.COPPER, (Supplier<Item>)IafItems.DRAGONSCALES_COPPER);
    public static final DragonArmor BLACK = new DragonArmor(DragonColor.BLACK, (Supplier<Item>)IafItems.DRAGONSCALES_BLACK);
    private final DragonColor color;
    private final Supplier<Item> repairItem;
    public RegistrySupplier<ArmorMaterial> material;
    public RegistrySupplier<Item> helmet;
    public RegistrySupplier<Item> chestplate;
    public RegistrySupplier<Item> leggings;
    public RegistrySupplier<Item> boots;
    public RegistrySupplier<ArmorMaterial> armorMaterial;

    public DragonArmor(DragonColor color, Supplier<Item> repairItem) {
        this.color = color;
        this.repairItem = repairItem;
        ARMORS.add(this);
    }

    public static void initArmors() {
        for (int i = 0; i < ARMORS.size(); ++i) {
            DragonArmor value = ARMORS.get(i);
            value.armorMaterial = IafArmorMaterials.register("armor_dragon_scales_" + (i + 1), new int[]{5, 7, 9, 5}, 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 2.0f, (Supplier<Ingredient>)new MemorizeSupplier(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)value.repairItem.get()})));
            String sub = "armor_" + value.color.name().toLowerCase(Locale.ROOT);
            value.helmet = IafItems.register(sub + "_helmet", () -> new ItemScaleArmor(value.color, value, (Holder<ArmorMaterial>)value.armorMaterial, ArmorItem.Type.HELMET));
            value.chestplate = IafItems.register(sub + "_chestplate", () -> new ItemScaleArmor(value.color, value, (Holder<ArmorMaterial>)value.armorMaterial, ArmorItem.Type.CHESTPLATE));
            value.leggings = IafItems.register(sub + "_leggings", () -> new ItemScaleArmor(value.color, value, (Holder<ArmorMaterial>)value.armorMaterial, ArmorItem.Type.LEGGINGS));
            value.boots = IafItems.register(sub + "_boots", () -> new ItemScaleArmor(value.color, value, (Holder<ArmorMaterial>)value.armorMaterial, ArmorItem.Type.BOOTS));
        }
    }

    public static List<DragonArmor> values() {
        return ImmutableList.copyOf(ARMORS);
    }

    public Item getScaleItem() {
        return this.repairItem.get();
    }

    public DragonColor getColor() {
        return this.color;
    }
}

