/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.dysoncubeproject.block.tile;

import com.buuz135.dysoncubeproject.Config;
import com.buuz135.dysoncubeproject.DCPContent;
import com.buuz135.dysoncubeproject.client.gui.DysonProgressGuiAddon;
import com.buuz135.dysoncubeproject.client.gui.SubscribeDysonGuiAddon;
import com.buuz135.dysoncubeproject.world.DysonSphereProgressSavedData;
import com.buuz135.dysoncubeproject.world.DysonSphereStructure;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.block.tile.ITickableBlockEntity;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class RayReceiverBlockEntity
extends BasicTile<RayReceiverBlockEntity>
implements IScreenAddonProvider,
ITickableBlockEntity<RayReceiverBlockEntity>,
MenuProvider,
IButtonHandler,
IContainerAddonProvider,
IHasAssetProvider,
IComponentHarness {
    @Save
    private String dysonSphereId = "";
    @Save
    private EnergyStorageComponent<RayReceiverBlockEntity> energyStorageComponent = new EnergyStorageComponent(Config.RAY_RECEIVER_POWER_BUFFER, 0, Integer.MAX_VALUE, 19, 22);
    @Save
    private float currentPitch = 270.0f;

    public RayReceiverBlockEntity(BasicTileBlock<RayReceiverBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, RayReceiverBlockEntity blockEntity) {
        float targetPitch;
        IEnergyStorage capability;
        if (level.isDay() && !level.isRaining() && level.canSeeSky(pos.above())) {
            DysonSphereProgressSavedData dyson = DysonSphereProgressSavedData.get(level);
            int extractingAmount = Math.min(Config.RAY_RECEIVER_EXTRACT_POWER, this.energyStorageComponent.getMaxEnergyStored() - this.energyStorageComponent.getEnergyStored());
            int extracted = dyson.getSpheres().computeIfAbsent(this.dysonSphereId, s -> new DysonSphereStructure()).extractPower(extractingAmount);
            this.energyStorageComponent.setEnergyStored(this.energyStorageComponent.getEnergyStored() + extracted);
        }
        if ((capability = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos.below(), (Object)Direction.UP)) != null && capability.canReceive()) {
            int received = capability.receiveEnergy(Math.min(Config.RAY_RECEIVER_EXTRACT_POWER, this.energyStorageComponent.getEnergyStored()), true);
            this.energyStorageComponent.setEnergyStored(this.energyStorageComponent.getEnergyStored() - received);
            capability.receiveEnergy(received, false);
        }
        if ((targetPitch = level.getTimeOfDay(1.0f) * 360.0f) >= 90.0f && targetPitch <= 270.0f) {
            targetPitch = 270.0f;
        }
        if (this.currentPitch % 360.0f <= targetPitch) {
            this.currentPitch = Math.min((this.currentPitch + 1.0f) % 360.0f, targetPitch);
        } else if (this.currentPitch > targetPitch) {
            this.currentPitch = Math.max(this.currentPitch - 1.0f, targetPitch);
        }
        this.syncObject(Float.valueOf(this.currentPitch));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Level level, BlockPos pos, BlockState state, RayReceiverBlockEntity blockEntity) {
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            if ((level.getGameTime() + pos.asLong()) % 340L == 0L && level.dayTime() % 24000L < 12000L && !level.isRaining()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance((SoundEvent)DCPContent.Sounds.RAY.get(), SoundSource.BLOCKS, 0.5f, 1.0f, level.getRandom(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
            }
        }
    }

    public ItemInteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        this.openGui(player);
        return ItemInteractionResult.SUCCESS;
    }

    public void openGui(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.openMenu((MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer((RegistryFriendlyByteBuf)buffer, (LocatorInstance)new TileEntityLocatorInstance(this.worldPosition)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
        list.addAll(this.energyStorageComponent.getScreenAddons());
        list.add(() -> new DysonProgressGuiAddon(this.dysonSphereId, 56, 24));
        list.add(() -> new SubscribeDysonGuiAddon(this.dysonSphereId, 9, 84));
        return list;
    }

    public IAssetProvider getAssetProvider() {
        return IAssetProvider.DEFAULT_PROVIDER;
    }

    @NotNull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList<IFactory<? extends IContainerAddon>> list = new ArrayList<IFactory<? extends IContainerAddon>>();
        list.addAll(this.energyStorageComponent.getContainerAddons());
        return list;
    }

    public void handleButtonMessage(int i, Player player, CompoundTag compoundTag) {
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new BasicAddonContainer((Object)this, (LocatorInstance)new TileEntityLocatorInstance(this.worldPosition), this.getWorldPosCallable(), inventoryPlayer, menu);
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)this.getBasicTileBlock().getDescriptionId()).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY));
    }

    public ContainerLevelAccess getWorldPosCallable() {
        return this.getLevel() != null ? ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos()) : ContainerLevelAccess.NULL;
    }

    public Level getComponentWorld() {
        return this.level;
    }

    public void markComponentForUpdate(boolean b) {
        this.markForUpdate();
    }

    public void markComponentDirty() {
        this.markForUpdate();
    }

    public String getDysonSphereId() {
        return this.dysonSphereId;
    }

    public void setDysonSphereId(String dysonSphereId) {
        this.dysonSphereId = dysonSphereId;
    }

    public EnergyStorageComponent<RayReceiverBlockEntity> getEnergyStorageComponent() {
        return this.energyStorageComponent;
    }

    public float getCurrentPitch() {
        return this.currentPitch;
    }
}

