/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.screen;

import com.sts15.enderdrives.screen.EnderDiskFrequencyScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class CustomImageButton
extends Button {
    private final ResourceLocation normalTexture;
    private final ResourceLocation hoverTexture;
    private final EnderDiskFrequencyScreen parent;

    public CustomImageButton(int x, int y, int width, int height, Button.OnPress onPress, ResourceLocation normalTexture, ResourceLocation hoverTexture, EnderDiskFrequencyScreen parent) {
        super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.normalTexture = normalTexture;
        this.hoverTexture = hoverTexture;
        this.parent = parent;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation texture = this.isHovered ? this.hoverTexture : this.normalTexture;
        graphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        MutableComponent label = Component.translatable((String)this.parent.currentScope.translationKey());
        int textWidth = Minecraft.getInstance().font.width((FormattedText)label);
        int textX = this.getX() + (this.width - textWidth) / 2;
        int textY = this.getY() + (this.height - 8) / 2;
        graphics.drawString(Minecraft.getInstance().font, (Component)label, textX, textY, EnderDiskFrequencyScreen.TEXT_COLOR, false);
        if (this.isHovered) {
            graphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)"screen.enderdrives.toggle_scope"), mouseX, mouseY);
        }
    }
}

