/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives.network.packet;

import com.sts15.enderdrives.items.EnderDiskItem;
import com.sts15.enderdrives.screen.FrequencyScope;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UpdateFrequencyPacket
implements CustomPacketPayload {
    private final int frequency;
    private final FrequencyScope scope;
    private final int transferMode;
    public static final CustomPacketPayload.Type<UpdateFrequencyPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)"update_frequency"));
    public static final StreamCodec<FriendlyByteBuf, UpdateFrequencyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, UpdateFrequencyPacket::getFrequency, (StreamCodec)ByteBufCodecs.VAR_INT.map(FrequencyScope::fromId, FrequencyScope::getId), UpdateFrequencyPacket::getScope, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateFrequencyPacket::getTransferMode, UpdateFrequencyPacket::new);

    public UpdateFrequencyPacket(int frequency, FrequencyScope scope, int transferMode) {
        this.frequency = frequency;
        this.scope = scope;
        this.transferMode = transferMode;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private int getFrequency() {
        return this.frequency;
    }

    private FrequencyScope getScope() {
        return this.scope;
    }

    private int getTransferMode() {
        return this.transferMode;
    }

    public static void handle(UpdateFrequencyPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player;
            ItemStack heldItem;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (heldItem = (player = (ServerPlayer)patt0$temp).getMainHandItem()).getItem() instanceof EnderDiskItem) {
                EnderDiskItem.setFrequency(heldItem, packet.frequency);
                EnderDiskItem.setScope(heldItem, packet.scope);
                EnderDiskItem.setTransferMode(heldItem, packet.transferMode);
                if (packet.scope == FrequencyScope.PERSONAL) {
                    EnderDiskItem.setOwnerUUID(heldItem, player.getUUID());
                }
            }
        });
    }
}

