/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.enderdrives;

import appeng.api.client.StorageCellModels;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.sts15.enderdrives.client.ClientTapeCache;
import com.sts15.enderdrives.commands.ModCommands;
import com.sts15.enderdrives.config.serverConfig;
import com.sts15.enderdrives.db.EnderDBManager;
import com.sts15.enderdrives.db.TapeDBManager;
import com.sts15.enderdrives.init.CreativeTabRegistry;
import com.sts15.enderdrives.inventory.EnderDiskInventory;
import com.sts15.enderdrives.inventory.TapeDiskInventory;
import com.sts15.enderdrives.items.EnderDiskItem;
import com.sts15.enderdrives.items.ItemInit;
import com.sts15.enderdrives.items.TapeDiskItem;
import com.sts15.enderdrives.network.NetworkHandler;
import com.sts15.enderdrives.network.packet.SyncConfigPacket;
import com.sts15.enderdrives.network.packet.SyncDisabledDrivesPacket;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@Mod(value="enderdrives")
public class EnderDrives {
    private static boolean isDatabaseActive = false;

    public EnderDrives(IEventBus modEventBus, ModContainer modContainer) {
        serverConfig.register(modContainer);
        Objects.requireNonNull(modContainer.getEventBus()).addListener(this::registerPayloads);
        ItemInit.register(modEventBus);
        CreativeTabRegistry.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        NetworkHandler.registerPackets(event);
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StorageCells.addCellHandler((ICellHandler)EnderDiskInventory.HANDLER);
            StorageCells.addCellHandler((ICellHandler)TapeDiskInventory.HANDLER);
        });
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStart(ServerStartingEvent e) {
        EnderDBManager.init();
        TapeDBManager.init();
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent e) {
        EnderDBManager.shutdown();
        TapeDBManager.shutdown();
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        int min = (Integer)serverConfig.FREQ_MIN.get();
        int max = (Integer)serverConfig.FREQ_MAX.get();
        SyncConfigPacket packet = new SyncConfigPacket(min, max);
        NetworkHandler.sendToClient(player2, packet);
        int bitmask = 0;
        if (((Boolean)serverConfig.ENDER_DISK_1K_TOGGLE.get()).booleanValue()) {
            bitmask |= 1;
        }
        if (((Boolean)serverConfig.ENDER_DISK_4K_TOGGLE.get()).booleanValue()) {
            bitmask |= 2;
        }
        if (((Boolean)serverConfig.ENDER_DISK_16K_TOGGLE.get()).booleanValue()) {
            bitmask |= 4;
        }
        if (((Boolean)serverConfig.ENDER_DISK_64K_TOGGLE.get()).booleanValue()) {
            bitmask |= 8;
        }
        if (((Boolean)serverConfig.ENDER_DISK_256K_TOGGLE.get()).booleanValue()) {
            bitmask |= 0x10;
        }
        if (((Boolean)serverConfig.ENDER_DISK_CREATIVE_TOGGLE.get()).booleanValue()) {
            bitmask |= 0x20;
        }
        if (((Boolean)serverConfig.TAPE_DISK_TOGGLE.get()).booleanValue()) {
            bitmask |= 0x40;
        }
        NetworkHandler.sendToClient(player2, new SyncDisabledDrivesPacket(bitmask));
    }

    public static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"enderdrives", (String)id);
    }

    @EventBusSubscriber(modid="enderdrives", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            StorageCellModels.registerModel((ItemLike)((ItemLike)ItemInit.ENDER_DISK_1K.get()), (ResourceLocation)EnderDrives.id("block/drive/ender_cell"));
            StorageCellModels.registerModel((ItemLike)((ItemLike)ItemInit.ENDER_DISK_4K.get()), (ResourceLocation)EnderDrives.id("block/drive/ender_cell"));
            StorageCellModels.registerModel((ItemLike)((ItemLike)ItemInit.ENDER_DISK_16K.get()), (ResourceLocation)EnderDrives.id("block/drive/ender_cell"));
            StorageCellModels.registerModel((ItemLike)((ItemLike)ItemInit.ENDER_DISK_64K.get()), (ResourceLocation)EnderDrives.id("block/drive/ender_cell"));
            StorageCellModels.registerModel((ItemLike)((ItemLike)ItemInit.ENDER_DISK_256K.get()), (ResourceLocation)EnderDrives.id("block/drive/ender_cell"));
            StorageCellModels.registerModel((ItemLike)((ItemLike)ItemInit.ENDER_DISK_creative.get()), (ResourceLocation)EnderDrives.id("block/drive/ender_cell"));
            StorageCellModels.registerModel((ItemLike)((ItemLike)ItemInit.TAPE_DISK.get()), (ResourceLocation)EnderDrives.id("block/drive/tape_cell"));
            event.enqueueWork(() -> {
                for (Item disk : new Item[]{(Item)ItemInit.ENDER_DISK_1K.get(), (Item)ItemInit.ENDER_DISK_4K.get(), (Item)ItemInit.ENDER_DISK_16K.get(), (Item)ItemInit.ENDER_DISK_64K.get(), (Item)ItemInit.ENDER_DISK_256K.get(), (Item)ItemInit.ENDER_DISK_creative.get(), (Item)ItemInit.TAPE_DISK.get()}) {
                    ItemProperties.register((Item)disk, (ResourceLocation)EnderDrives.id("status"), (stack, level, entity, seed) -> {
                        CellState state = EnderDiskInventory.getCellStateForStack(stack);
                        return switch (state) {
                            default -> throw new MatchException(null, null);
                            case CellState.ABSENT, CellState.EMPTY -> 0.0f;
                            case CellState.NOT_EMPTY -> 1.0f;
                            case CellState.TYPES_FULL, CellState.FULL -> 2.0f;
                        };
                    });
                }
            });
        }

        @SubscribeEvent
        public static void registerColorHandlers(RegisterColorHandlersEvent.Item event) {
            event.register((stack, tintIndex) -> {
                if (tintIndex == 1) {
                    if (stack.getItem() instanceof EnderDiskItem) {
                        CellState state = EnderDiskInventory.getCellStateForStack(stack);
                        return switch (state) {
                            default -> throw new MatchException(null, null);
                            case CellState.ABSENT -> 0;
                            case CellState.EMPTY -> 65280;
                            case CellState.NOT_EMPTY -> 255;
                            case CellState.TYPES_FULL, CellState.FULL -> 16753920;
                        };
                    }
                    if (stack.getItem() instanceof TapeDiskItem) {
                        UUID id = TapeDiskItem.getTapeId(stack);
                        if (id == null) {
                            return 0;
                        }
                        int typeCount = ClientTapeCache.getTypeCount(id);
                        long byteCount = ClientTapeCache.getByteCount(id);
                        int typeLimit = ((TapeDiskItem)stack.getItem()).getTypeLimit(stack);
                        long byteLimit = TapeDBManager.getByteLimit(id);
                        int typePercent = typeLimit > 0 ? typeCount * 100 / typeLimit : 0;
                        int bytePercent = byteLimit > 0L ? (int)(byteCount * 100L / byteLimit) : 0;
                        int usagePercent = Math.max(typePercent, bytePercent);
                        if ((usagePercent = Math.min(usagePercent, 100)) >= 99) {
                            return 0xFF5555;
                        }
                        if (usagePercent >= 75) {
                            return 0xFFAA00;
                        }
                        if (usagePercent > 0) {
                            return 43775;
                        }
                        return 65280;
                    }
                }
                return -1;
            }, new ItemLike[]{(ItemLike)ItemInit.ENDER_DISK_1K.get(), (ItemLike)ItemInit.ENDER_DISK_4K.get(), (ItemLike)ItemInit.ENDER_DISK_16K.get(), (ItemLike)ItemInit.ENDER_DISK_64K.get(), (ItemLike)ItemInit.ENDER_DISK_256K.get(), (ItemLike)ItemInit.ENDER_DISK_creative.get(), (ItemLike)ItemInit.TAPE_DISK.get()});
        }
    }
}

