/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.machines.api.component.CMDataComponents;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeComponent;
import dev.compactmods.machines.api.room.upgrade.RoomUpgradeComponentType;
import dev.compactmods.machines.api.room.upgrade.component.RoomUpgradeComponentList;
import dev.compactmods.machines.command.argument.Suggestors;
import dev.compactmods.machines.feature.CMFeatureFlags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RoomUpgradesSubcommand {
    public static LiteralArgumentBuilder<CommandSourceStack> make() {
        LiteralArgumentBuilder subRoot = (LiteralArgumentBuilder)Commands.literal((String)"upgrades").requires(cs -> CMFeatureFlags.ROOM_UPGRADES.isSubsetOf(cs.enabledFeatures()) && cs.hasPermission(2));
        subRoot.then(Commands.literal((String)"add").then(Commands.argument((String)"upgrade", (ArgumentType)ResourceLocationArgument.id()).suggests(Suggestors.ROOM_UPGRADE_TYPES).executes(RoomUpgradesSubcommand::applyUpgrade)));
        subRoot.then(Commands.literal((String)"remove").then(Commands.argument((String)"room", (ArgumentType)StringArgumentType.string()).suggests(Suggestors.ROOM_UPGRADE_TYPES).executes(RoomUpgradesSubcommand::removeUpgrade)));
        return subRoot;
    }

    @Nullable
    private static RoomUpgradeComponentType<?> getTargetedUpgradeType(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ResourceLocation upgradeType = ResourceLocationArgument.getId(ctx, (String)"upgrade");
        return (RoomUpgradeComponentType)src.getServer().registryAccess().registryOrThrow(RoomUpgradeComponentType.REGISTRY_KEY).get(upgradeType);
    }

    private static int applyUpgrade(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        RoomUpgradeComponentType<?> realUpgradeType = RoomUpgradesSubcommand.getTargetedUpgradeType(ctx);
        if (realUpgradeType == null) {
            return 0;
        }
        ItemStack heldItem = player.getMainHandItem();
        RoomUpgradeComponentList currentUpgrades = (RoomUpgradeComponentList)heldItem.get((Supplier)CMDataComponents.UPGRADE_LIST_COMPONENT);
        if (!realUpgradeType.canApplyTo(heldItem)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"That upgrade cannot be applied to the held item."));
            return 0;
        }
        if (currentUpgrades != null) {
            ArrayList<RoomUpgradeComponent> addedList = new ArrayList<RoomUpgradeComponent>(currentUpgrades.components());
            addedList.add((RoomUpgradeComponent)realUpgradeType.constructor().get());
            RoomUpgradeComponentList newList = new RoomUpgradeComponentList(addedList);
            heldItem.set((Supplier)CMDataComponents.UPGRADE_LIST_COMPONENT, (Object)newList);
        } else {
            RoomUpgradeComponentList newList = new RoomUpgradeComponentList(List.of((RoomUpgradeComponent)realUpgradeType.constructor().get()));
            heldItem.set((Supplier)CMDataComponents.UPGRADE_LIST_COMPONENT, (Object)newList);
        }
        return 0;
    }

    private static int removeUpgrade(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        RoomUpgradeComponentType<?> realUpgradeType = RoomUpgradesSubcommand.getTargetedUpgradeType(ctx);
        ItemStack heldItem = player.getMainHandItem();
        RoomUpgradeComponentList currentUpgrades = (RoomUpgradeComponentList)heldItem.get((Supplier)CMDataComponents.UPGRADE_LIST_COMPONENT);
        if (currentUpgrades != null) {
            RoomUpgradeComponentList newList = new RoomUpgradeComponentList(currentUpgrades.components());
            newList.components().removeIf(ru -> ru.getType().equals((Object)realUpgradeType));
            heldItem.set((Supplier)CMDataComponents.UPGRADE_LIST_COMPONENT, (Object)newList);
        }
        return 0;
    }
}

