/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.components.FluidContents;
import mob_grinding_utils.components.MGUComponents;
import mob_grinding_utils.models.ModelTankBlock;
import mob_grinding_utils.util.RL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class TileTankStackItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation TANK_TEXTURE = RL.mgu("textures/tiles/tank.png");
    private static final ResourceLocation TANK_SINK_TEXTURE = RL.mgu("textures/tiles/tank_sink.png");
    private static final ResourceLocation TANK_JUMBO_TEXTURE = RL.mgu("textures/tiles/tank_jumbo.png");
    private final ModelTankBlock tank_model;
    private FluidStack fluidStack;

    public TileTankStackItemRenderer(BlockEntityRenderDispatcher renderer, EntityModelSet modelSet) {
        super(renderer, modelSet);
        EntityModelSet EntityModelSetThatIsntNULL = Minecraft.getInstance().getEntityModels();
        this.tank_model = new ModelTankBlock(EntityModelSetThatIsntNULL.bakeLayer(ModelLayers.TANK));
    }

    public void renderByItem(ItemStack stack, @Nonnull ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlayIn) {
        matrixStack.pushPose();
        matrixStack.translate(0.5, 1.5, 0.5);
        matrixStack.scale(-0.9999f, -0.9999f, 0.9999f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.tank_model.renderToBuffer(matrixStack, bufferIn.getBuffer(RenderType.entitySmoothCutout((ResourceLocation)this.getTexture(stack.getItem()))), combinedLight, OverlayTexture.NO_OVERLAY, -1);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.popPose();
        this.fluidStack = ((FluidContents)stack.getOrDefault(MGUComponents.FLUID, (Object)FluidContents.EMPTY)).get();
        float fluidLevel = this.fluidStack.getAmount();
        if (fluidLevel < 1.0f) {
            return;
        }
        float tankMax = 32000.0f;
        if (stack.getItem() == ModBlocks.JUMBO_TANK.getItem()) {
            tankMax = 1024000.0f;
        }
        float height = 0.96875f / tankMax * fluidLevel;
        IClientFluidTypeExtensions fluidExtensions = IClientFluidTypeExtensions.of((Fluid)this.fluidStack.getFluid());
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidExtensions.getStillTexture());
        VertexConsumer buffer = bufferIn.getBuffer(RenderType.translucent());
        int fluidColor = fluidExtensions.getTintColor();
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.0, 0.0);
        float yMin = 0.0f;
        float xMax = 1.984375f;
        float zMax = 1.984375f;
        float xMin = 0.015625f;
        float zMin = 0.015625f;
        yMin = 0.015625f;
        float alpha = 1.0f;
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
        matrixStack.popPose();
    }

    private ResourceLocation getTexture(Item item) {
        return item == ModBlocks.JUMBO_TANK.getItem() ? TANK_JUMBO_TEXTURE : (item == ModBlocks.TANK_SINK.getItem() ? TANK_SINK_TEXTURE : TANK_TEXTURE);
    }

    private void renderCuboid(VertexConsumer buffer, PoseStack matrixStack, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite, float red, float green, float blue, float alpha, int combinedLight) {
        float uMin = textureAtlasSprite.getU0();
        float uMax = textureAtlasSprite.getU1();
        float vMin = textureAtlasSprite.getV0();
        float vMax = textureAtlasSprite.getV1();
        float vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMax, red, green, blue, alpha, combinedLight);
    }

    private void addVertexWithUV(VertexConsumer buffer, PoseStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, int combinedLight) {
        buffer.addVertex(matrixStack.last().pose(), x / 2.0f, y, z / 2.0f).setColor(red, green, blue, alpha).setUv(u, v).setUv2(combinedLight, 240).setNormal(1.0f, 0.0f, 0.0f);
    }
}

