/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.models.ModelAHConnect;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import mob_grinding_utils.util.RL;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityAbsorptionRenderer
implements BlockEntityRenderer<TileEntityAbsorptionHopper> {
    private static final ResourceLocation ITEM_TEXTURE = RL.mgu("textures/tiles/absorption_hopper_connects_items.png");
    private static final ResourceLocation FLUID_TEXTURE = RL.mgu("textures/tiles/absorption_hopper_connects_fluids.png");
    private final ModelAHConnect connectionModel;

    public TileEntityAbsorptionRenderer(BlockEntityRendererProvider.Context context) {
        this.connectionModel = new ModelAHConnect(context.bakeLayer(ModelLayers.ABSORPTION_HOPPER));
    }

    public void render(TileEntityAbsorptionHopper tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.hasLevel()) {
            return;
        }
        BlockState state = tile.getLevel().getBlockState(tile.getBlockPos());
        if (state == null || state.getBlock() != ModBlocks.ABSORPTION_HOPPER.getBlock()) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        for (Direction facing : Direction.values()) {
            if (tile.status[facing.ordinal()] == TileEntityAbsorptionHopper.EnumStatus.STATUS_OUTPUT_ITEM) {
                matrixStack.pushPose();
                this.getRotTranslation(matrixStack, facing);
                this.connectionModel.renderToBuffer(matrixStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)ITEM_TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, 0x7F7F7FFF);
                matrixStack.popPose();
            }
            if (tile.status[facing.ordinal()] != TileEntityAbsorptionHopper.EnumStatus.STATUS_OUTPUT_FLUID) continue;
            matrixStack.pushPose();
            this.getRotTranslation(matrixStack, facing);
            this.connectionModel.renderToBuffer(matrixStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)FLUID_TEXTURE)), combinedLight, OverlayTexture.NO_OVERLAY, 0x7F7F7FFF);
            matrixStack.popPose();
        }
        matrixStack.popPose();
        if (!tile.showRenderBox) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.translate(-5.0E-4, -5.0E-4, -5.0E-4);
        matrixStack.scale(0.999f, 0.999f, 0.999f);
        LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (AABB)tile.getAABBForRender(), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        matrixStack.popPose();
    }

    public void getRotTranslation(PoseStack matrixStack, Direction facing) {
        switch (facing) {
            case UP: {
                matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                break;
            }
            case DOWN: {
                break;
            }
            case NORTH: {
                matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                matrixStack.mulPose(Axis.XN.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                matrixStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrixStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
        }
    }

    public AABB getRenderBoundingBox(TileEntityAbsorptionHopper blockEntity) {
        return blockEntity.getAABBWithModifiers();
    }
}

