/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.awt.Color;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockDelightfulDirt;
import mob_grinding_utils.blocks.BlockDreadfulDirt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ModColourManager {
    private static final Minecraft MINECRAFT = Minecraft.getInstance();

    public static void registerColourHandlers() {
        BlockColors blockColors = MINECRAFT.getBlockColors();
        ItemColors itemColors = MINECRAFT.getItemColors();
        ModColourManager.registerBlockColourHandlers(blockColors);
        ModColourManager.registerItemColourHandlers(blockColors, itemColors);
    }

    private static void registerBlockColourHandlers(BlockColors blockColors) {
        BlockColor dreadfulDirtColour = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return new Color(153, 50, 153).getRGB() & 0xFFFFFF;
            }
            return new Color(153, 50, 153).getRGB() & 0xFFFFFF;
        };
        BlockColor delightfulDirtColour = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return new Color(190, 255, 0).getRGB() & 0xFFFFFF;
            }
            return new Color(190, 255, 0).getRGB() & 0xFFFFFF;
        };
        blockColors.register(dreadfulDirtColour, new Block[]{ModBlocks.DREADFUL_DIRT.getBlock()});
        blockColors.register(delightfulDirtColour, new Block[]{ModBlocks.DELIGHTFUL_DIRT.getBlock()});
    }

    private static void registerItemColourHandlers(BlockColors blockColors, ItemColors itemColors) {
        ItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            BlockState state = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
            if (state.getBlock() instanceof BlockDreadfulDirt) {
                return blockColors.getColor(state, null, null, tintIndex);
            }
            if (state.getBlock() instanceof BlockDelightfulDirt) {
                return blockColors.getColor(state, null, null, tintIndex);
            }
            return -1;
        };
        itemColors.register(itemBlockColourHandler, new ItemLike[]{ModBlocks.DREADFUL_DIRT.getItem()});
        itemColors.register(itemBlockColourHandler, new ItemLike[]{ModBlocks.DELIGHTFUL_DIRT.getItem()});
    }
}

