/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.solarefficiency;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.client.util.RenderHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.guicomponent.solarefficiency.SolarEfficiencyBar;

public final class SolarEfficiencyBarClient
extends GuiComponentClient<SolarEfficiencyBar.Params, SolarEfficiencyBar.Data> {
    public SolarEfficiencyBarClient(SolarEfficiencyBar.Params params, SolarEfficiencyBar.Data data) {
        super((Object)params, (Object)data);
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    private final class Renderer
    implements ClientComponentRenderer {
        private static final ResourceLocation EFFICIENCY_BAR = MI.id((String)"textures/gui/efficiency_bar.png");
        private static final ResourceLocation SOLAR_STATE = EI.id("textures/gui/container/solar_state.png");
        private final int WIDTH = 100;
        private final int HEIGHT = 2;

        private Renderer() {
        }

        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            guiGraphics.blit(EFFICIENCY_BAR, x + ((SolarEfficiencyBar.Params)SolarEfficiencyBarClient.this.params).renderX() - 1, y + ((SolarEfficiencyBar.Params)SolarEfficiencyBarClient.this.params).renderY() - 1, 0.0f, 2.0f, 102, 4, 102, 6);
            int barPixels = (int)((float)((SolarEfficiencyBar.Data)SolarEfficiencyBarClient.this.data).efficiency() / 100.0f * 100.0f);
            guiGraphics.blit(EFFICIENCY_BAR, x + ((SolarEfficiencyBar.Params)SolarEfficiencyBarClient.this.params).renderX(), y + ((SolarEfficiencyBar.Params)SolarEfficiencyBarClient.this.params).renderY(), 0.0f, 0.0f, barPixels, 2, 102, 6);
            guiGraphics.blit(SOLAR_STATE, x + ((SolarEfficiencyBar.Params)SolarEfficiencyBarClient.this.params).renderX() - 20, y + ((SolarEfficiencyBar.Params)SolarEfficiencyBarClient.this.params).renderY() + 1 - 6, ((SolarEfficiencyBar.Data)SolarEfficiencyBarClient.this.data).working() ? 0.0f : 12.0f, 0.0f, 12, 12, 24, 12);
        }

        public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (RenderHelper.isPointWithinRectangle((int)((SolarEfficiencyBar.Params)SolarEfficiencyBarClient.this.params).renderX(), (int)((SolarEfficiencyBar.Params)SolarEfficiencyBarClient.this.params).renderY(), (int)100, (int)2, (double)(cursorX - x), (double)(cursorY - y))) {
                ArrayList lines = Lists.newArrayList();
                lines.add(EI.text().solarEfficiency(((SolarEfficiencyBar.Data)SolarEfficiencyBarClient.this.data).efficiency()));
                if (((SolarEfficiencyBar.Data)SolarEfficiencyBarClient.this.data).calcification() > 0) {
                    lines.add(EI.text().calcificationPercentage(((SolarEfficiencyBar.Data)SolarEfficiencyBarClient.this.data).calcification()));
                }
                if (((SolarEfficiencyBar.Data)SolarEfficiencyBarClient.this.data).energyProduced() > 0L) {
                    lines.add(EI.text().generatingEuPerTick(((SolarEfficiencyBar.Data)SolarEfficiencyBarClient.this.data).energyProduced()));
                }
                guiGraphics.renderTooltip(font, (List)lines, Optional.empty(), cursorX, cursorY);
            }
        }
    }
}

