/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.solarefficiency;

import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.extended_industrialization.EI;

public final class SolarEfficiencyBar
implements GuiComponentServer<Params, Data> {
    public static final GuiComponentServer.Type<Params, Data> TYPE = new GuiComponentServer.Type(EI.id("solar_efficiency_bar"), Params.STREAM_CODEC, Data.STREAM_CODEC);
    private final Params params;
    private final Supplier<Boolean> workingSupplier;
    private final Supplier<Integer> efficiencySupplier;
    private final Supplier<Integer> calcificationSupplier;
    private final Supplier<Long> energyProducedSupplier;

    private SolarEfficiencyBar(Params params, Supplier<Boolean> workingSupplier, Supplier<Integer> efficiencySupplier, Supplier<Integer> calcificationSupplier, Supplier<Long> energyProducedSupplier) {
        this.params = params;
        this.workingSupplier = workingSupplier;
        this.efficiencySupplier = efficiencySupplier;
        this.calcificationSupplier = calcificationSupplier;
        this.energyProducedSupplier = energyProducedSupplier;
    }

    public static SolarEfficiencyBar calcification(Params params, Supplier<Boolean> workingSupplier, Supplier<Integer> efficiencySupplier, Supplier<Integer> calcificationSupplier) {
        return new SolarEfficiencyBar(params, workingSupplier, efficiencySupplier, calcificationSupplier, () -> -1L);
    }

    public static SolarEfficiencyBar energyProduced(Params params, Supplier<Boolean> workingSupplier, Supplier<Integer> efficiencySupplier, Supplier<Long> energyProducedSupplier) {
        return new SolarEfficiencyBar(params, workingSupplier, efficiencySupplier, () -> -1, energyProducedSupplier);
    }

    public Params getParams() {
        return this.params;
    }

    public Data extractData() {
        return new Data(this.workingSupplier.get(), this.efficiencySupplier.get(), this.calcificationSupplier.get(), this.energyProducedSupplier.get());
    }

    public GuiComponentServer.Type<Params, Data> getType() {
        return TYPE;
    }

    public record Params(int renderX, int renderY) {
        public static final StreamCodec<ByteBuf, Params> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Params::renderX, (StreamCodec)ByteBufCodecs.VAR_INT, Params::renderY, Params::new);
    }

    public record Data(boolean working, int efficiency, int calcification, long energyProduced) {
        public static final StreamCodec<ByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, Data::working, (StreamCodec)ByteBufCodecs.VAR_INT, Data::efficiency, (StreamCodec)ByteBufCodecs.VAR_INT, Data::calcification, (StreamCodec)ByteBufCodecs.VAR_LONG, Data::energyProduced, Data::new);
    }
}

