/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.tesla;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.swedz.extended_industrialization.proxy.EIProxy;
import net.swedz.tesseract.neoforge.proxy.Proxies;

public final class TeslaBuzzingComponent
implements MachineComponent.ClientOnly {
    private final MachineBlockEntity machine;
    private final SoundEvent sound;
    private final SoundSource source;
    private final Supplier<Boolean> shouldBuzz;
    private final Supplier<Float> buzzingPitch;
    private boolean buzzing;

    public TeslaBuzzingComponent(MachineBlockEntity machine, SoundEvent sound, SoundSource source, Supplier<Boolean> shouldBuzz, Supplier<Float> buzzingPitch) {
        this.machine = machine;
        this.sound = sound;
        this.source = source;
        this.shouldBuzz = shouldBuzz;
        this.buzzingPitch = buzzingPitch;
    }

    public void tick() {
        if (!this.buzzing && this.shouldBuzz.get().booleanValue()) {
            this.buzzing = true;
            ((EIProxy)Proxies.get(EIProxy.class)).startTeslaCoilLoopSound(this.machine.getBlockPos(), this.sound, this.source, () -> this.machine.isRemoved() || this.shouldBuzz.get() == false, this.buzzingPitch, () -> {
                this.buzzing = false;
            });
        }
    }

    public void writeClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
    }

    public void readClientNbt(CompoundTag tag, HolderLookup.Provider registries) {
    }
}

