/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.chainer.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.extended_industrialization.machines.component.chainer.handler.SlotChainerHandler;
import net.swedz.extended_industrialization.machines.component.chainer.wrapper.SlotInventoryWrapper;
import net.swedz.tesseract.neoforge.helper.TransferHelper;

public final class ChainerFluidHandler
extends SlotChainerHandler<IFluidHandler>
implements IFluidHandler {
    public ChainerFluidHandler(ChainerLinks chainerLinks) {
        super(chainerLinks);
    }

    @Override
    public void invalidate() {
        ArrayList wrappers = Lists.newArrayList();
        int slots = 0;
        for (IFluidHandler handler : this.getMachineLinks().fluidHandlers()) {
            int handlerSlots = handler.getTanks();
            wrappers.add(new SlotInventoryWrapper<IFluidHandler>(handler, slots, handlerSlots));
            slots += handlerSlots;
        }
        this.wrappers = Collections.unmodifiableList(wrappers);
        this.wrappersSlotMap = Maps.newConcurrentMap();
        this.slots = slots;
    }

    public int getTanks() {
        return this.slots;
    }

    public FluidStack getFluidInTank(int tank) {
        SlotInventoryWrapper wrapper = this.getWrapper(tank);
        return wrapper != null ? ((IFluidHandler)wrapper.handler()).getFluidInTank(wrapper.toLocalSlot(tank)) : FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        SlotInventoryWrapper wrapper = this.getWrapper(tank);
        return wrapper != null ? ((IFluidHandler)wrapper.handler()).getTankCapacity(wrapper.toLocalSlot(tank)) : 0;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        SlotInventoryWrapper wrapper = this.getWrapper(tank);
        return wrapper != null && ((IFluidHandler)wrapper.handler()).isFluidValid(wrapper.toLocalSlot(tank), stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.chainerLinks.doesAllowOperation()) {
            return 0;
        }
        ArrayList storages = Lists.newArrayList();
        for (SlotInventoryWrapper wrapper : this.wrappers) {
            storages.add((IFluidHandler)wrapper.handler());
        }
        return TransferHelper.distributeFluid((List)storages, (FluidStack)resource, (boolean)action.simulate());
    }

    private FluidStack drain(Fluid fluid, int maxAmount, IFluidHandler.FluidAction action) {
        if (!this.chainerLinks.doesAllowOperation()) {
            return FluidStack.EMPTY;
        }
        ArrayList storages = Lists.newArrayList();
        for (SlotInventoryWrapper wrapper : this.wrappers) {
            storages.add((IFluidHandler)wrapper.handler());
        }
        return TransferHelper.collectFluid((List)storages, (Fluid)fluid, (int)maxAmount, (boolean)action.simulate());
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource.getFluid(), resource.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(null, maxDrain, action);
    }

    private static final class Bucket {
        private final SlotInventoryWrapper<IFluidHandler> wrapper;
        private final int simulationResult;

        private Bucket(SlotInventoryWrapper<IFluidHandler> wrapper, int simulationResult) {
            this.wrapper = wrapper;
            this.simulationResult = simulationResult;
        }
    }
}

