/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.compat.viewer.common;

import aztech.modern_industrialization.client.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIFluids;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.datamap.FertilizerPotency;

public final class FluidFertilizerCategory
extends ViewerCategory<Fluid> {
    public FluidFertilizerCategory() {
        super(Fluid.class, EI.id("fluid_fertilizers"), (Component)EI.text().fluidFertilizers(), EIFluids.NPK_FERTILIZER.asFluid().getBucket().getDefaultInstance(), 150, 45);
    }

    public ResourceLocation getRecipeId(Fluid fluid) {
        ResourceLocation key = BuiltInRegistries.FLUID.getKey((Object)fluid);
        return EI.id("/fluid_fertilizer/%s/%s".formatted(key.getNamespace(), key.getPath()));
    }

    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
        consumer.accept(new ItemLike[]{EIItems.valueOf("electric_farmer")});
    }

    public void buildRecipes(RecipeManager recipeManager, RegistryAccess registryAccess, Consumer<Fluid> consumer) {
        for (Fluid fluid : registryAccess.registryOrThrow(Registries.FLUID)) {
            if (FertilizerPotency.getFor(fluid) == null) continue;
            consumer.accept(fluid);
        }
    }

    public void buildLayout(Fluid recipe, ViewerCategory.LayoutBuilder builder) {
        builder.inputSlot(15, 15).variant((TransferVariant)FluidVariant.of((Fluid)recipe));
    }

    public void buildWidgets(Fluid recipe, ViewerCategory.WidgetList widgets) {
        FertilizerPotency fertilizerPotency = FertilizerPotency.getFor(recipe);
        MutableComponent rate = EI.text().fluidFertilizersTime((float)fertilizerPotency.tickRate() / 20.0f);
        widgets.secondaryText((Component)rate, 40.0f, 14.0f);
        MutableComponent cost = EI.text().fluidFertilizersConsumes(fertilizerPotency.mbToConsumePerFertilizerTick());
        widgets.secondaryText((Component)cost, 40.0f, 24.0f);
    }
}

