/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.nanosuit.decorations;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.client.nanosuit.NanoArmorLayer;
import net.swedz.extended_industrialization.client.nanosuit.decorations.NanoSuitDecorationModel;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitArmorItem;
import net.swedz.extended_industrialization.item.nanosuit.decoration.NanoSuitDecoration;

public final class WingNanoSuitDecorationModel<T extends LivingEntity>
extends NanoSuitDecorationModel<T> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(EI.id("nano_armor"), "wing");

    public static LayerDefinition createLayer() {
        float wingRotation = 0.2f;
        CubeDeformation deformation = new CubeDeformation(0.0f);
        MeshDefinition mesh = WingNanoSuitDecorationModel.createMesh((CubeDeformation)deformation, (float)0.0f);
        PartDefinition root = WingNanoSuitDecorationModel.createHumanoidAlias(mesh);
        PartDefinition body = root.getChild("body");
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -12.0f, 5.0f, 32.0f, 32.0f, 0.0f), PartPose.rotation((float)0.0f, (float)(-wingRotation), (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -12.0f, 5.0f, -32.0f, 32.0f, 0.0f), PartPose.rotation((float)0.0f, (float)wingRotation, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    private static PartDefinition createHumanoidAlias(MeshDefinition mesh) {
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", new CubeListBuilder(), PartPose.ZERO);
        body.addOrReplaceChild("left_wing", new CubeListBuilder(), PartPose.ZERO);
        body.addOrReplaceChild("right_wing", new CubeListBuilder(), PartPose.ZERO);
        return root;
    }

    private static ResourceLocation getTexture(int layerIndex) {
        return EI.id("textures/models/armor/nano_decorations/wing%s.png".formatted(layerIndex == 1 ? "_overlay" : ""));
    }

    public WingNanoSuitDecorationModel(ModelPart root) {
        super(root, NanoSuitDecoration.WING);
    }

    @Override
    public void render(T entity, EquipmentSlot slot, ItemStack stack, NanoSuitArmorItem item, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, ArmorMaterial.Layer armorLayer, int armorLayerIndex, int armorLayerColor, boolean armorLayerIsColored) {
        ResourceLocation texture = WingNanoSuitDecorationModel.getTexture(armorLayerIndex);
        RenderType renderType = NanoArmorLayer.decorationRenderType(armorLayerIndex, item, texture, armorLayerIsColored);
        VertexConsumer buffer = bufferSource.getBuffer(renderType);
        this.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, armorLayerColor);
    }

    protected Iterable<ModelPart> headParts() {
        return List.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return List.of(this.body);
    }
}

