/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.ber.tesla;

import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.renderable.BakedModelRenderable;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIClient;
import net.swedz.extended_industrialization.EIClientRenderTypes;
import net.swedz.extended_industrialization.EIComponents;
import net.swedz.extended_industrialization.client.ber.tesla.arc.TeslaArcBuilder;
import net.swedz.extended_industrialization.client.ber.tesla.arc.TeslaArcPoint;
import net.swedz.extended_industrialization.client.ber.tesla.arc.TeslaArcRenderer;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaArcInstance;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaBehavior;
import net.swedz.extended_industrialization.client.model.tesla.TeslaBakedModel;
import net.swedz.extended_industrialization.client.model.tesla.TeslaUnbakedModel;
import net.swedz.extended_industrialization.compat.continuity.ContinuityModelUnwrapper;
import net.swedz.extended_industrialization.item.teslalinkable.SelectedTeslaNetwork;
import net.swedz.extended_industrialization.machines.blockentity.tesla.TeslaParticleGeneratorMachineBlockEntity;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetworkPart;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.helper.CubeOverlayRenderHelper;
import org.joml.Vector3f;
import org.joml.Vector4f;

@EventBusSubscriber(modid="extended_industrialization", value={Dist.CLIENT})
public final class TeslaPartRenderer {
    private static final Map<BlockPos, TeslaArcInstance> TESLA_ARCS = Maps.newConcurrentMap();

    private static void renderHighlight(MachineBlockEntity machine, float partialTick, PoseStack matrices, MultiBufferSource buffer, int light, int overlay) {
        BlockPos pos = machine.getBlockPos();
        if (machine instanceof TeslaNetworkPart) {
            TeslaNetworkPart part = (TeslaNetworkPart)machine;
            TeslaPartRenderer.getHeldNetworkKey().ifPresent(networkKey -> {
                if (part.hasNetwork() && part.getNetworkKey().equals(networkKey)) {
                    matrices.pushPose();
                    matrices.translate(-0.005, -0.005, -0.005);
                    matrices.scale(1.01f, 1.01f, 1.01f);
                    CubeOverlayRenderHelper.render((PoseStack)matrices, (MultiBufferSource)buffer, (float)0.43359375f, (float)0.43359375f, (float)1.0f, (int)overlay);
                    matrices.popPose();
                }
            });
        } else if (machine instanceof TeslaParticleGeneratorMachineBlockEntity && TeslaPartRenderer.isHoldingWrench()) {
            matrices.pushPose();
            matrices.translate(-0.005, -0.005, -0.005);
            matrices.scale(1.01f, 1.01f, 1.01f);
            CubeOverlayRenderHelper.render((PoseStack)matrices, (MultiBufferSource)buffer, (float)1.0f, (float)1.0f, (float)1.0f, (int)overlay);
            matrices.popPose();
        }
    }

    private static Optional<WorldPos> getHeldNetworkKey() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player.getMainHandItem().has(EIComponents.SELECTED_TESLA_NETWORK) ? Optional.of(((SelectedTeslaNetwork)player.getMainHandItem().get(EIComponents.SELECTED_TESLA_NETWORK)).key()) : (player.getOffhandItem().has(EIComponents.SELECTED_TESLA_NETWORK) ? Optional.of(((SelectedTeslaNetwork)player.getOffhandItem().get(EIComponents.SELECTED_TESLA_NETWORK)).key()) : Optional.empty());
    }

    private static boolean isHoldingWrench() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player.getMainHandItem().is(MITags.WRENCHES) || player.getOffhandItem().is(MITags.WRENCHES);
    }

    @SubscribeEvent
    private static void onLevelUnload(LevelEvent.Unload event) {
        TESLA_ARCS.clear();
    }

    public static void removeArcInstance(BlockPos pos) {
        TESLA_ARCS.remove(pos);
    }

    public static TeslaArcInstance getArcInstance(BlockPos pos) {
        TeslaBehavior behavior;
        TeslaBakedModel tesla;
        MachineBlockEntity machine;
        ClientLevel level = Minecraft.getInstance().level;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MachineBlockEntity && (machine = (MachineBlockEntity)blockEntity) instanceof TeslaBehavior && (tesla = TeslaPartRenderer.getTeslaModel((behavior = (TeslaBehavior)machine).getTeslaModelLocation())) != null && tesla.arcs() != null) {
            return TESLA_ARCS.computeIfAbsent(pos, __ -> new TeslaArcInstance(pos, () -> machine.orientation.facingDirection, () -> TeslaPartRenderer.getTeslaModel(behavior.getTeslaModelLocation())));
        }
        return null;
    }

    private static TeslaBakedModel getTeslaModel(ResourceLocation location) {
        ModelManager modelManager = Minecraft.getInstance().getModelManager();
        BakedModel model = modelManager.getModel(ModelResourceLocation.standalone((ResourceLocation)location));
        if ((model = ContinuityModelUnwrapper.unwrap(model)) instanceof TeslaBakedModel) {
            TeslaBakedModel teslaModel = (TeslaBakedModel)model;
            return teslaModel;
        }
        EI.LOGGER.warn("Model {} should have been a TeslaBakedModel, but was {}", (Object)location, (Object)model.getClass());
        return null;
    }

    private static void renderArcBounds(MachineBlockEntity machine, TeslaBakedModel tesla, PoseStack matrices, MultiBufferSource buffer) {
        TeslaUnbakedModel.Arcs arcs = tesla.arcs();
        if (arcs != null && (arcs.hasRandomBounds() || arcs.attachesToNearbyEntities()) && Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
            AABB box;
            matrices.pushPose();
            VertexConsumer consumer = buffer.getBuffer(RenderType.lines());
            Vec3 position = machine.getBlockPos().getCenter();
            Direction direction = machine.orientation.facingDirection;
            if (arcs.hasRandomBounds()) {
                box = arcs.worldIncludeBounds(position, direction).move(position.scale(-1.0)).move(0.5, 0.5, 0.5);
                LevelRenderer.renderLineBox((PoseStack)matrices, (VertexConsumer)consumer, (AABB)box, (float)0.75f, (float)1.0f, (float)0.75f, (float)1.0f);
                box = arcs.worldExcludeBounds(position, direction).move(position.scale(-1.0)).move(0.5, 0.5, 0.5);
                LevelRenderer.renderLineBox((PoseStack)matrices, (VertexConsumer)consumer, (AABB)box, (float)1.0f, (float)0.75f, (float)0.75f, (float)1.0f);
            }
            if (arcs.attachesToNearbyEntities()) {
                box = arcs.worldNearbyEntitiesBounds(position, direction).move(position.scale(-1.0)).move(0.5, 0.5, 0.5);
                LevelRenderer.renderLineBox((PoseStack)matrices, (VertexConsumer)consumer, (AABB)box, (float)0.75f, (float)0.75f, (float)1.0f, (float)1.0f);
            }
            matrices.popPose();
        }
    }

    private static void renderArcs(MachineBlockEntity machine, TeslaBakedModel tesla, Vector3f color, float partialTick, PoseStack matrices, MultiBufferSource buffer, int light, int overlay) {
        TeslaUnbakedModel.Arcs arcs = tesla.arcs();
        if (arcs != null) {
            TeslaArcInstance arcInstance = TeslaPartRenderer.getArcInstance(machine.getBlockPos());
            if (arcInstance == null) {
                return;
            }
            for (TeslaArcBuilder trail : arcInstance.getTrails()) {
                List<TeslaArcPoint> points = trail.points();
                if (points.size() < 2) continue;
                boolean instant = arcs.duration() == 0;
                float alpha = 0.9f;
                if (!instant) {
                    int ticks = points.getFirst().timeActive();
                    int halfPoints = points.size() / 2;
                    if (ticks == 0 || ticks == 1) {
                        points = points.subList(0, (int)((float)halfPoints * partialTick) + (ticks == 1 ? halfPoints : 0));
                    }
                    alpha *= ticks == 0 ? partialTick : (ticks == arcs.duration() ? 1.0f - partialTick : 1.0f);
                }
                matrices.pushPose();
                VertexConsumer consumer = buffer.getBuffer(EIClientRenderTypes.TESLA_ARC);
                TeslaArcRenderer.renderArc(matrices, consumer, points, i -> Float.valueOf((1.0f - i.floatValue()) * arcs.widthScale()), color.x(), color.y(), color.z(), alpha);
                matrices.popPose();
            }
        }
    }

    private static void renderPlasma(MachineBlockEntity machine, TeslaBakedModel tesla, Vector3f color, float partialTick, PoseStack matrices, MultiBufferSource buffer, int light, int overlay) {
        TeslaUnbakedModel.Plasma plasma = tesla.plasma();
        if (plasma != null) {
            matrices.pushPose();
            Vec3 worldPosition = machine.getBlockPos().getCenter();
            Vec3 worldOffset = plasma.worldOffset(worldPosition, machine.orientation.facingDirection);
            Vec3 offset = worldOffset.subtract(worldPosition).add(0.5, 0.5, 0.5);
            matrices.translate(offset.x(), offset.y(), offset.z());
            float modelScale = plasma.scale();
            matrices.scale(modelScale, modelScale, modelScale);
            float textureScale = plasma.textureScale();
            float speed = plasma.speed();
            BakedModelRenderable.of((BakedModel)tesla).render(matrices, buffer, texture -> EIClientRenderTypes.TESLA_PLASMA.apply(Float.valueOf(textureScale), Float.valueOf(speed)), light, overlay, partialTick, new BakedModelRenderable.Context(null, new Direction[1], RandomSource.create(), 1835364215L, ModelData.EMPTY, new Vector4f(color.x(), color.y(), color.z(), 0.8f)));
            matrices.popPose();
        }
    }

    static void render(MachineBlockEntity machine, float partialTick, PoseStack matrices, MultiBufferSource buffer, int light, int overlay) {
        TeslaPartRenderer.renderHighlight(machine, partialTick, matrices, buffer, light, overlay);
        if (EIClient.config().renderTeslaAnimations() && machine instanceof TeslaBehavior) {
            TeslaBakedModel tesla;
            TeslaBehavior behavior = (TeslaBehavior)machine;
            int renderDistance = EIClient.config().teslaAnimationsRenderDistance();
            if ((renderDistance == 0 || Minecraft.getInstance().player.position().closerThan((Position)machine.getBlockPos().getCenter(), (double)renderDistance)) && (tesla = TeslaPartRenderer.getTeslaModel(behavior.getTeslaModelLocation())) != null) {
                Vector3f color = behavior.getTeslaColor();
                TeslaPartRenderer.renderArcBounds(machine, tesla, matrices, buffer);
                if (behavior.shouldTeslaRender()) {
                    TeslaPartRenderer.renderArcs(machine, tesla, color, partialTick, matrices, buffer, light, overlay);
                    TeslaPartRenderer.renderPlasma(machine, tesla, color, partialTick, matrices, buffer, light, overlay);
                }
            }
        }
    }
}

