/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storagemonitor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorInsertionStrategy;
import com.ultramega.refinedtypes.registry.Types;
import com.ultramega.refinedtypes.type.TypeStack;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;

public class EnergyStorageMonitorInsertionStrategy
implements StorageMonitorInsertionStrategy {
    public Optional<ItemStack> insert(ResourceKey configuredResource, ItemStack stack, Actor actor, Network network) {
        if (!(configuredResource instanceof EnergyResource)) {
            return Optional.empty();
        }
        EnergyResource configuredEnergyResource = (EnergyResource)configuredResource;
        RootStorage rootStorage = (RootStorage)network.getComponent(StorageNetworkComponent.class);
        ItemStack modifiedStack = stack.copy();
        return Optional.ofNullable((ILongEnergyStorage)modifiedStack.getCapability(ILongEnergyStorage.ITEM)).map(handler -> this.handleInsert(actor, configuredEnergyResource, (ILongEnergyStorage)handler, rootStorage, modifiedStack));
    }

    @Nullable
    private ItemStack handleInsert(Actor actor, EnergyResource configuredEnergyResource, ILongEnergyStorage handler, RootStorage rootStorage, ItemStack modifiedStack) {
        TypeStack extractedSimulated = new TypeStack(Types.FE.get(), handler.extract(Long.MAX_VALUE, true));
        if (extractedSimulated.isEmpty()) {
            return null;
        }
        long insertedSimulated = this.tryInsert(actor, configuredEnergyResource, extractedSimulated, rootStorage);
        if (insertedSimulated == 0L) {
            return null;
        }
        TypeStack extracted = new TypeStack(Types.FE.get(), handler.extract(insertedSimulated, false));
        if (extracted.isEmpty()) {
            return null;
        }
        this.doInsert(actor, extracted, rootStorage);
        return modifiedStack;
    }

    private long tryInsert(Actor actor, EnergyResource configuredResource, TypeStack result, RootStorage rootStorage) {
        if (!result.type().equals(configuredResource.type())) {
            return 0L;
        }
        return rootStorage.insert((ResourceKey)EnergyResource.createEnergyResource(), result.amount(), Action.SIMULATE, actor);
    }

    private void doInsert(Actor actor, TypeStack result, RootStorage rootStorage) {
        rootStorage.insert((ResourceKey)EnergyResource.createEnergyResource(), result.amount(), Action.EXECUTE, actor);
    }
}

