/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.storage.source;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Items;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;

public enum SourceStorageVariant implements StringRepresentable,
StorageVariant
{
    B_64(64L),
    B_256(256L),
    B_1024(1024L),
    B_8192(8192L),
    B_65536(65536L),
    B_262144(262144L),
    B_1048576(0x100000L),
    B_8388608(0x800000L),
    INFINITE(null);

    private final String name;
    private final ResourceLocation storageDiskId;
    private final ResourceLocation storageBlockId;
    private final ResourceLocation storagePartId;
    @Nullable
    private final Long capacityInBuckets;

    private SourceStorageVariant(Long capacityInBuckets) {
        this.name = capacityInBuckets == null ? "infinite" : capacityInBuckets + "b";
        this.storagePartId = RefinedTypesUtil.createRefinedTypesIdentifier(this.name + "_source_storage_part");
        this.storageDiskId = RefinedTypesUtil.createRefinedTypesIdentifier(this.name + "_source_storage_disk");
        this.storageBlockId = RefinedTypesUtil.createRefinedTypesIdentifier(this.name + "_source_storage_block");
        this.capacityInBuckets = capacityInBuckets;
    }

    @Nullable
    public Long getCapacityInBuckets() {
        return this.capacityInBuckets;
    }

    @Nullable
    public Long getCapacity() {
        if (this.capacityInBuckets == null) {
            return null;
        }
        return this.capacityInBuckets * Platform.INSTANCE.getBucketAmount();
    }

    public Item getStoragePart() {
        return Items.getSourceStoragePart(this);
    }

    public ResourceLocation getStorageDiskId() {
        return this.storageDiskId;
    }

    public ResourceLocation getStorageBlockId() {
        return this.storageBlockId;
    }

    public ResourceLocation getStoragePartId() {
        return this.storagePartId;
    }

    public String getName() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }
}

