/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.networkenergizer;

import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.support.AbstractBaseBlock;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.networkenergizer.NetworkEnergizerBlockEntity;
import com.ultramega.refinedtypes.registry.BlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class NetworkEnergizerBlock
extends AbstractBaseBlock
implements EntityBlock {
    private static final Component HELP = RefinedTypesUtil.createRefinedTypesTranslation("item", "network_energizer.help");
    private static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private static final AbstractBlockEntityTicker<NetworkEnergizerBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(BlockEntities::getNetworkEnergizer, ACTIVE);

    public NetworkEnergizerBlock() {
        super(BlockConstants.PROPERTIES);
    }

    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NetworkEnergizerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return TICKER.get(level, type);
    }

    public BlockItem createBlockItem() {
        return new NetworkNodeBlockItem((Block)this, HELP);
    }
}

