/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.grid;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.api.grid.GridResourceAttributeKeys;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResourceAttributeKey;
import com.ultramega.refinedtypes.grid.energy.EnergyGridResource;
import com.ultramega.refinedtypes.grid.soul.SoulGridResource;
import com.ultramega.refinedtypes.grid.source.SourceGridResource;
import com.ultramega.refinedtypes.registry.Types;
import com.ultramega.refinedtypes.type.Type;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import com.ultramega.refinedtypes.type.soul.SoulResource;
import com.ultramega.refinedtypes.type.source.SourceResource;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.neoforged.fml.ModList;

public class TypeGridResourceFactory
implements ResourceRepositoryMapper<GridResource> {
    public GridResource apply(ResourceKey resource) {
        Type type = this.extractType(resource);
        String name = this.getName(type);
        String modId = this.getModId(type);
        String modName = this.getModName(modId);
        Map<GridResourceAttributeKeys, Supplier> attributes = Map.of(GridResourceAttributeKeys.MOD_ID, Suppliers.ofInstance(Set.of(modId)), GridResourceAttributeKeys.MOD_NAME, Suppliers.ofInstance(Set.of(modName)), GridResourceAttributeKeys.TAGS, Suppliers.ofInstance(this.getTags(type)), GridResourceAttributeKeys.TOOLTIP, Suppliers.ofInstance(Set.of(this.getTooltip(type))));
        Function<GridResourceAttributeKey, Set<String>> attributesFunction = k -> attributes.getOrDefault(k, Collections::emptySet).get();
        ResourceKey resourceKey = resource;
        Objects.requireNonNull(resourceKey);
        ResourceKey resourceKey2 = resourceKey;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnergyResource.class, SourceResource.class, SoulResource.class}, (Object)resourceKey2, n)) {
            case 0 -> {
                EnergyResource energyResource = (EnergyResource)resourceKey2;
                yield new EnergyGridResource(energyResource, name, attributesFunction);
            }
            case 1 -> {
                SourceResource sourceResource = (SourceResource)resourceKey2;
                yield new SourceGridResource(sourceResource, name, attributesFunction);
            }
            case 2 -> {
                SoulResource soulResource = (SoulResource)resourceKey2;
                yield new SoulGridResource(soulResource, name, attributesFunction);
            }
            default -> throw new IllegalArgumentException("Unsupported resource: " + String.valueOf(resource));
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Type extractType(ResourceKey resource) {
        ResourceKey resourceKey = resource;
        Objects.requireNonNull(resourceKey);
        ResourceKey resourceKey2 = resourceKey;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnergyResource.class, SourceResource.class, SoulResource.class}, (Object)resourceKey2, n)) {
            case 0: {
                Type type;
                EnergyResource energyResource = (EnergyResource)resourceKey2;
                try {
                    Type type2;
                    Type type22;
                    type = type22 = (type2 = energyResource.type());
                    return type;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                Type type;
                SourceResource sourceResource = (SourceResource)resourceKey2;
                {
                    Type type3;
                    Type type4;
                    type = type4 = (type3 = sourceResource.type());
                    return type;
                }
            }
            case 2: {
                Type type;
                SoulResource soulResource = (SoulResource)resourceKey2;
                {
                    Type type4;
                    Type type5;
                    type = type5 = (type4 = soulResource.type());
                    return type;
                }
            }
        }
        throw new IllegalArgumentException("Type couldn't be identified for resource: " + String.valueOf(resource));
    }

    private Set<String> getTags(Type type) {
        return Types.TYPE_REGISTRY.getResourceKey((Object)type).flatMap(arg_0 -> Types.TYPE_REGISTRY.getHolder(arg_0)).stream().flatMap(Holder::tags).map(tagKey -> tagKey.location().getPath()).collect(Collectors.toSet());
    }

    private String getModId(Type type) {
        return Types.TYPE_REGISTRY.getKey((Object)type).getNamespace();
    }

    private String getTooltip(Type type) {
        return this.getName(type);
    }

    private String getModName(String modId) {
        return ModList.get().getModContainerById(modId).map(container -> container.getModInfo().getDisplayName()).orElse("");
    }

    private String getName(Type type) {
        return type.getDisplayName().getString();
    }
}

