/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.datagen.recipe;

import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.misc.ProcessorItem;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Tags;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class RecipeProviderImpl
extends RecipeProvider {
    public RecipeProviderImpl(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        RecipeOutput arsOutput = output.withConditions(new ICondition[]{new ModLoadedCondition("ars_nouveau")});
        RecipeOutput soulsOutput = output.withConditions(new ICondition[]{new ModLoadedCondition("industrialforegoingsouls")});
        for (EnergyStorageVariant energyStorageVariant : EnergyStorageVariant.values()) {
            this.recipeStorageDisk(energyStorageVariant.getStoragePart(), com.ultramega.refinedtypes.registry.Items.getEnergyStorageDisk(energyStorageVariant), output);
            this.recipeStorageBlock(energyStorageVariant.getStoragePart(), com.ultramega.refinedtypes.registry.Items.getEnergyStorageBlock(energyStorageVariant), Items.COPPER_BLOCK, output);
            this.recipeDiskFromStorageHousing(energyStorageVariant.getStoragePart(), com.ultramega.refinedtypes.registry.Items.getEnergyStorageDisk(energyStorageVariant), output);
        }
        for (Enum enum_ : SourceStorageVariant.values()) {
            this.recipeStorageDisk(((SourceStorageVariant)enum_).getStoragePart(), com.ultramega.refinedtypes.registry.Items.getSourceStorageDisk((SourceStorageVariant)enum_), arsOutput);
            this.recipeStorageBlock(((SourceStorageVariant)enum_).getStoragePart(), com.ultramega.refinedtypes.registry.Items.getSourceStorageBlock((SourceStorageVariant)enum_), Items.REDSTONE_BLOCK, arsOutput);
            this.recipeDiskFromStorageHousing(((SourceStorageVariant)enum_).getStoragePart(), com.ultramega.refinedtypes.registry.Items.getSourceStorageDisk((SourceStorageVariant)enum_), arsOutput);
        }
        for (Enum enum_ : SoulStorageVariant.values()) {
            this.recipeStorageDisk(((SoulStorageVariant)enum_).getStoragePart(), com.ultramega.refinedtypes.registry.Items.getSoulStorageDisk((SoulStorageVariant)enum_), soulsOutput);
            this.recipeStorageBlock(((SoulStorageVariant)enum_).getStoragePart(), com.ultramega.refinedtypes.registry.Items.getSoulStorageBlock((SoulStorageVariant)enum_), Items.REDSTONE_BLOCK, soulsOutput);
            this.recipeDiskFromStorageHousing(((SoulStorageVariant)enum_).getStoragePart(), com.ultramega.refinedtypes.registry.Items.getSoulStorageDisk((SoulStorageVariant)enum_), soulsOutput);
        }
        this.registerFirstPartRecipe(Items.COPPER_BLOCK, EnergyStorageVariant.K_64.getStoragePart(), output);
        this.registerFirstPartRecipe((Item)ItemsRegistry.MAGE_FIBER.get(), SourceStorageVariant.B_64.getStoragePart(), arsOutput);
        this.registerFirstPartRecipe(Items.SCULK, SoulStorageVariant.K_1.getStoragePart(), soulsOutput);
        com.refinedmods.refinedstorage.common.content.Items items = com.refinedmods.refinedstorage.common.content.Items.INSTANCE;
        record Upgrade(StorageVariant from, StorageVariant to, Item processor, Item upgradeBlock) {
        }
        List<Upgrade> energyUpgrades = List.of(new Upgrade(EnergyStorageVariant.K_64, EnergyStorageVariant.K_256, items.getProcessor(ProcessorItem.Type.BASIC), Items.GOLD_BLOCK), new Upgrade(EnergyStorageVariant.K_256, EnergyStorageVariant.K_1024, items.getProcessor(ProcessorItem.Type.IMPROVED), Items.GOLD_BLOCK), new Upgrade(EnergyStorageVariant.K_1024, EnergyStorageVariant.K_8192, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.DIAMOND_BLOCK), new Upgrade(EnergyStorageVariant.K_8192, EnergyStorageVariant.K_65536, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.DIAMOND_BLOCK), new Upgrade(EnergyStorageVariant.K_65536, EnergyStorageVariant.K_262144, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.EMERALD_BLOCK), new Upgrade(EnergyStorageVariant.K_262144, EnergyStorageVariant.K_1048576, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.EMERALD_BLOCK), new Upgrade(EnergyStorageVariant.K_1048576, EnergyStorageVariant.K_8388608, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.NETHERITE_BLOCK), new Upgrade(EnergyStorageVariant.K_8388608, EnergyStorageVariant.INFINITE, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.NETHERITE_BLOCK));
        List<Upgrade> sourceUgrades = List.of(new Upgrade(SourceStorageVariant.B_64, SourceStorageVariant.B_256, items.getProcessor(ProcessorItem.Type.BASIC), Items.GOLD_BLOCK), new Upgrade(SourceStorageVariant.B_256, SourceStorageVariant.B_1024, items.getProcessor(ProcessorItem.Type.IMPROVED), Items.GOLD_BLOCK), new Upgrade(SourceStorageVariant.B_1024, SourceStorageVariant.B_8192, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.DIAMOND_BLOCK), new Upgrade(SourceStorageVariant.B_8192, SourceStorageVariant.B_65536, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.DIAMOND_BLOCK), new Upgrade(SourceStorageVariant.B_65536, SourceStorageVariant.B_262144, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.EMERALD_BLOCK), new Upgrade(SourceStorageVariant.B_262144, SourceStorageVariant.B_1048576, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.EMERALD_BLOCK), new Upgrade(SourceStorageVariant.B_1048576, SourceStorageVariant.B_8388608, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.NETHERITE_BLOCK), new Upgrade(SourceStorageVariant.B_8388608, SourceStorageVariant.INFINITE, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.NETHERITE_BLOCK));
        List<Upgrade> list = List.of(new Upgrade(SoulStorageVariant.K_1, SoulStorageVariant.K_8, items.getProcessor(ProcessorItem.Type.BASIC), Items.GOLD_BLOCK), new Upgrade(SoulStorageVariant.K_8, SoulStorageVariant.K_64, items.getProcessor(ProcessorItem.Type.IMPROVED), Items.GOLD_BLOCK), new Upgrade(SoulStorageVariant.K_64, SoulStorageVariant.K_512, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.DIAMOND_BLOCK), new Upgrade(SoulStorageVariant.K_512, SoulStorageVariant.K_4096, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.DIAMOND_BLOCK), new Upgrade(SoulStorageVariant.K_4096, SoulStorageVariant.K_32768, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.EMERALD_BLOCK), new Upgrade(SoulStorageVariant.K_32768, SoulStorageVariant.K_262144, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.EMERALD_BLOCK), new Upgrade(SoulStorageVariant.K_262144, SoulStorageVariant.K_2097152, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.NETHERITE_BLOCK), new Upgrade(SoulStorageVariant.K_2097152, SoulStorageVariant.INFINITE, items.getProcessor(ProcessorItem.Type.ADVANCED), Items.NETHERITE_BLOCK));
        energyUpgrades.forEach(up -> this.registerUpgradePartRecipe(up.from(), up.to(), up.processor(), Items.COPPER_BLOCK, up.upgradeBlock(), output));
        sourceUgrades.forEach(up -> this.registerUpgradePartRecipe(up.from(), up.to(), up.processor(), Items.REDSTONE_BLOCK, up.upgradeBlock(), arsOutput));
        list.forEach(up -> this.registerUpgradePartRecipe(up.from(), up.to(), up.processor(), Items.REDSTONE_BLOCK, up.upgradeBlock(), soulsOutput));
    }

    private void recipeStorageDisk(Item storagePart, Item result, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("GRG").pattern("RPR").pattern("EEE").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('P'), (ItemLike)storagePart).define(Character.valueOf('E'), (ItemLike)Items.REDSTONE_BLOCK).unlockedBy("has_storage_part", RecipeProviderImpl.has((ItemLike)storagePart)).save(output, RefinedTypesUtil.createRefinedTypesIdentifier("disk/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
    }

    private void recipeStorageBlock(Item storagePart, Item result, Item resourceBlock, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("EPE").pattern("EME").pattern("ERE").define(Character.valueOf('M'), (ItemLike)Blocks.INSTANCE.getMachineCasing()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('P'), (ItemLike)storagePart).define(Character.valueOf('E'), (ItemLike)resourceBlock).unlockedBy("has_storage_part", RecipeProviderImpl.has((ItemLike)storagePart)).save(output, RefinedTypesUtil.createRefinedTypesIdentifier("blocks/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
    }

    private void registerFirstPartRecipe(Item craftBlock, Item result, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("SES").pattern("GRG").pattern("SGS").define(Character.valueOf('S'), Tags.SILICON).define(Character.valueOf('E'), (ItemLike)craftBlock).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_craft_block", RecipeProviderImpl.has((ItemLike)craftBlock)).save(output, RefinedTypesUtil.createRefinedTypesIdentifier("part/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
    }

    private void registerUpgradePartRecipe(StorageVariant prevPart, StorageVariant resultPart, Item processor, Item resourceBlock, Item upgradeBlock, RecipeOutput output) {
        Item prevPartItem = prevPart.getStoragePart();
        Item resultPartItem = resultPart.getStoragePart();
        if (prevPartItem == null || resultPartItem == null) {
            return;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPartItem).pattern("PEP").pattern("SRS").pattern("PSP").define(Character.valueOf('P'), (ItemLike)processor).define(Character.valueOf('E'), (ItemLike)resourceBlock).define(Character.valueOf('S'), (ItemLike)prevPartItem).define(Character.valueOf('R'), (ItemLike)upgradeBlock).unlockedBy("has_prev_part", RecipeProviderImpl.has((ItemLike)prevPartItem)).save(output, RefinedTypesUtil.createRefinedTypesIdentifier("part/" + BuiltInRegistries.ITEM.getKey((Object)resultPartItem).getPath()));
    }

    private void recipeDiskFromStorageHousing(Item storagePart, Item result, RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).requires((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStorageHousing()).requires((ItemLike)storagePart).unlockedBy("has_storage_part", RecipeProviderImpl.has((ItemLike)storagePart)).save(output, RefinedTypesUtil.createRefinedTypesIdentifier("part/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath()));
    }
}

