/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.refinedtypes.datagen;

import com.ultramega.refinedtypes.RefinedTypesUtil;
import com.ultramega.refinedtypes.registry.Blocks;
import com.ultramega.refinedtypes.storage.energy.EnergyStorageVariant;
import com.ultramega.refinedtypes.storage.soul.SoulStorageVariant;
import com.ultramega.refinedtypes.storage.source.SourceStorageVariant;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStateProviderImpl
extends BlockStateProvider {
    private static final String BLOCK_PREFIX = "block";
    private final ExistingFileHelper existingFileHelper;

    public BlockStateProviderImpl(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "refinedtypes", existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    protected void registerStatesAndModels() {
        this.registerEnergyStorageBlocks();
        this.registerSourceStorageBlocks();
        this.registerSoulStorageBlocks();
    }

    private void registerEnergyStorageBlocks() {
        for (EnergyStorageVariant variant : EnergyStorageVariant.values()) {
            String name = variant.getName() + "_energy_storage_block";
            this.simpleBlockWithItem(Blocks.getEnergyStorageBlock(variant), this.modelFile(RefinedTypesUtil.createRefinedTypesIdentifier("block/" + name)));
        }
    }

    private void registerSourceStorageBlocks() {
        for (SourceStorageVariant variant : SourceStorageVariant.values()) {
            String name = variant.getName() + "_source_storage_block";
            this.simpleBlockWithItem(Blocks.getSourceStorageBlock(variant), this.modelFile(RefinedTypesUtil.createRefinedTypesIdentifier("block/" + name)));
        }
    }

    private void registerSoulStorageBlocks() {
        for (SoulStorageVariant variant : SoulStorageVariant.values()) {
            String name = variant.getName() + "_soul_storage_block";
            this.simpleBlockWithItem(Blocks.getSoulStorageBlock(variant), this.modelFile(RefinedTypesUtil.createRefinedTypesIdentifier("block/" + name)));
        }
    }

    private ModelFile modelFile(ResourceLocation location) {
        return new ModelFile.ExistingModelFile(location, this.existingFileHelper);
    }
}

