/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.integration.jei.category.grinding;

import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.common.kinetics.grindstone.GrindingRecipe;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;
import plus.dragons.createenchantmentindustry.integration.jei.category.grinding.AnimatedGrindstone;
import plus.dragons.createenchantmentindustry.util.CEILang;

public class GrindingCategory
implements IRecipeCategory<RecipeHolder<GrindingRecipe>> {
    public static final RecipeType<RecipeHolder<GrindingRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)CEIRecipes.GRINDING.getId());
    private final Component title = CEILang.translate("recipe.grinding", new Object[0]).component();
    private final IDrawable icon = new ItemIcon(() -> CEIBlocks.GRINDSTONE_DRAIN.asStack());
    private final AnimatedGrindstone grindstone = new AnimatedGrindstone();

    public RecipeType<RecipeHolder<GrindingRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 177;
    }

    public int getHeight() {
        return 70;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<GrindingRecipe> holder, IFocusGroup focuses) {
        GrindingRecipe recipe = (GrindingRecipe)holder.value();
        Ingredient ingredient = (Ingredient)recipe.getIngredients().get(0);
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 32).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients(ingredient);
        NonNullList fluidIngredients = recipe.getFluidIngredients();
        if (!fluidIngredients.isEmpty()) {
            CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)27, (int)51, (SizedFluidIngredient)((SizedFluidIngredient)fluidIngredients.getFirst()));
        }
        List results = recipe.getRollableResults();
        int i = 0;
        NonNullList fluidResults = recipe.getFluidResults();
        if (!fluidResults.isEmpty()) {
            CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)130, (int)32, (FluidStack)((FluidStack)fluidResults.getFirst()));
            ++i;
        }
        for (ProcessingOutput output : results) {
            int xOffset = i % 2 == 0 ? 0 : 19;
            int yOffset = i / 2 * -19;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 130 + xOffset, 32 + yOffset).setBackground(CreateRecipeCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(CreateRecipeCategory.addStochasticTooltip((ProcessingOutput)output));
            ++i;
        }
    }

    public void draw(RecipeHolder<GrindingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 115, 5);
        AllGuiTextures.JEI_SHADOW.render(graphics, 61, 52);
        this.grindstone.draw(graphics, 68, 32);
    }
}

