/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.kinetics.grindstone;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.common.kinetics.grindstone.GrindstoneDrainBlockEntity;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;

public class GrindstoneDrainRenderer
extends KineticBlockEntityRenderer<GrindstoneDrainBlockEntity> {
    public GrindstoneDrainRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(GrindstoneDrainBlockEntity drain, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        this.renderItems(drain, partialTicks, poseStack, buffer, light, overlay);
        this.renderFluid(drain, partialTicks, poseStack, buffer, light);
        super.renderSafe((KineticBlockEntity)drain, partialTicks, poseStack, buffer, light, overlay);
    }

    protected BlockState getRenderedBlockState(GrindstoneDrainBlockEntity be) {
        Direction.Axis axis = GrindstoneDrainRenderer.getRotationAxisOf((KineticBlockEntity)be);
        return (BlockState)CEIBlocks.MECHANICAL_GRINDSTONE.getDefaultState().setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis);
    }

    protected void renderItems(GrindstoneDrainBlockEntity drain, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (drain.inventory.isEmpty()) {
            return;
        }
        boolean alongZ = ((Direction)drain.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getAxis() == Direction.Axis.Z;
        float duration = drain.inventory.recipeDuration;
        boolean moving = duration != 0.0f;
        float offset = moving ? drain.inventory.remainingTime / duration : 0.0f;
        float processingSpeed = Mth.clamp((float)(drain.getRelativeSpeed() / 32.0f), (float)1.0f, (float)128.0f);
        if (moving) {
            offset = Mth.clamp((float)(offset + (-partialTicks + 0.5f) * processingSpeed / duration), (float)0.125f, (float)1.0f);
            if (!drain.inventory.appliedRecipe) {
                offset += 1.0f;
            }
            offset /= 2.0f;
        }
        if (drain.getSpeed() == 0.0f) {
            offset = 0.5f;
        } else if (drain.getSpeed() < 0.0f ^ alongZ) {
            offset = 1.0f - offset;
        }
        int count = 0;
        for (int i = 1; i < drain.inventory.getSlots(); ++i) {
            if (drain.inventory.getStackInSlot(i).isEmpty()) continue;
            ++count;
        }
        poseStack.pushPose();
        if (alongZ) {
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        poseStack.translate(count <= 1 ? 0.5f : 0.25f, 0.0f, 1.0f - offset);
        poseStack.translate(alongZ ? -1.0f : 0.0f, 0.0f, 0.0f);
        float yDelta = Mth.sin((float)(offset * (float)Math.PI));
        float yOffset = Mth.lerp((float)yDelta, (float)0.8125f, (float)1.0f);
        int rendered = 0;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        for (int i = 0; i < drain.inventory.getSlots(); ++i) {
            ItemStack stack = drain.inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            BakedModel modelWithOverrides = itemRenderer.getModel(stack, drain.getLevel(), null, 0);
            boolean blockItem = modelWithOverrides.isGui3d();
            poseStack.pushPose();
            poseStack.translate(0.0f, blockItem ? yOffset + 0.1125f : yOffset, 0.0f);
            if (i > 0 && count > 1) {
                poseStack.translate(0.5f / (float)(count - 1) * (float)rendered, 0.0f, 0.0f);
                TransformStack.of((PoseStack)poseStack).nudge(i * 133);
            }
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            itemRenderer.render(stack, ItemDisplayContext.FIXED, false, poseStack, buffer, light, overlay, modelWithOverrides);
            ++rendered;
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void renderFluid(GrindstoneDrainBlockEntity drain, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        SmartFluidTankBehaviour tank = drain.tank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f) {
            float min = 0.125f;
            float max = min + 0.75f;
            float minY = 0.3125f;
            NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, min, minY, min, max, minY + (level *= 0.4375f), max, buffer, poseStack, light, false, false);
        }
    }
}

