/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.fakelevel;

import java.util.function.Function;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public interface IFakeLevelBlockGetter
extends BlockGetter {
    public int getSizeX();

    public int getSizeZ();

    default public int getMinX() {
        return 0;
    }

    default public int getMinBuildHeight() {
        return 0;
    }

    default public int getMinZ() {
        return 0;
    }

    default public int getMaxX() {
        return this.getMinX() + this.getSizeX();
    }

    default public int getMaxZ() {
        return this.getMinZ() + this.getSizeZ();
    }

    default public boolean isPosInside(BlockPos pos) {
        return this.getMinX() <= pos.getX() && pos.getX() < this.getMaxX() && this.getMinBuildHeight() <= pos.getY() && pos.getY() < this.getMaxBuildHeight() && this.getMinZ() <= pos.getZ() && pos.getZ() < this.getMaxZ();
    }

    default public boolean isPosOutside(BlockPos pos) {
        return !this.isPosInside(pos);
    }

    default public FluidState getFluidState(BlockPos pos) {
        return this.isPosInside(pos) ? this.getBlockState(pos).getFluidState() : Fluids.EMPTY.defaultFluidState();
    }

    default public void describeSelfInCrashReport(CrashReportCategory category) {
    }

    default public BlockState getRawBlockState(BlockPos pos) {
        return this.isPosInside(pos) ? this.getBlockState(pos) : null;
    }

    default public Function<BlockPos, @Nullable BlockState> getRawBlockStateFunction() {
        return this::getRawBlockState;
    }

    default public AABB getAABB() {
        return new AABB((double)this.getMinX(), (double)this.getMinBuildHeight(), (double)this.getMinZ(), (double)this.getMaxX(), (double)this.getMaxBuildHeight(), (double)this.getMaxZ());
    }
}

