/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.common.config;

import com.ldtteam.common.language.LanguageHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.server.TickTask;
import net.minecraft.util.thread.BlockableEventLoop;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfiguration {
    public static final String DEFAULT_KEY_PREFIX = "blockui.config.default.";
    public static final String COMMENT_SUFFIX = ".comment";
    final List<ConfigWatcher<?>> watchers = new ArrayList();
    private final ModConfigSpec.Builder builder;
    private final String modId;
    private ModConfigSpec.RestartType nextRestartType = ModConfigSpec.RestartType.NONE;

    protected AbstractConfiguration(ModConfigSpec.Builder builder, String modId) {
        this.builder = builder;
        this.modId = modId;
    }

    protected void createCategory(String key) {
        if (this.nextRestartType != ModConfigSpec.RestartType.NONE) {
            throw new IllegalStateException("Categories cannot have worldRestart flag!");
        }
        this.buildBase(key, null).push(key);
    }

    protected void swapToCategory(String key) {
        this.finishCategory();
        this.createCategory(key);
    }

    protected void finishCategory() {
        this.builder.pop();
    }

    private String nameTKey(String key) {
        return this.modId + ".config." + key;
    }

    private String commentTKey(String key) {
        return this.nameTKey(key) + COMMENT_SUFFIX;
    }

    private ModConfigSpec.Builder buildBase(String key, @Nullable String defaultDesc) {
        switch (this.nextRestartType) {
            case WORLD: {
                this.builder.worldRestart();
                break;
            }
            case GAME: {
                this.builder.gameRestart();
                break;
            }
        }
        this.nextRestartType = ModConfigSpec.RestartType.NONE;
        Object comment = AbstractConfiguration.translate(this.commentTKey(key), new Object[0]);
        if (defaultDesc != null && !defaultDesc.isBlank()) {
            comment = (String)comment + " " + defaultDesc;
        }
        return this.builder.comment((String)comment).translation(this.nameTKey(key));
    }

    private static String translate(String key, Object ... args) {
        String translated = LanguageHandler.translateKey(key);
        return args.length == 0 ? translated : translated.formatted(args);
    }

    protected AbstractConfiguration requiresWorldRestart() {
        return this.requires(ModConfigSpec.RestartType.WORLD);
    }

    protected AbstractConfiguration requiresGameRestart() {
        return this.requires(ModConfigSpec.RestartType.GAME);
    }

    protected AbstractConfiguration requires(ModConfigSpec.RestartType restartType) {
        this.nextRestartType = restartType;
        return this;
    }

    protected ModConfigSpec.BooleanValue defineBoolean(String key, boolean defaultValue) {
        return this.buildBase(key, AbstractConfiguration.translate("blockui.config.default.boolean", defaultValue)).define(key, defaultValue);
    }

    protected ModConfigSpec.IntValue defineInteger(String key, int defaultValue) {
        return this.defineInteger(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    protected ModConfigSpec.IntValue defineInteger(String key, int defaultValue, int min, int max) {
        return this.buildBase(key, AbstractConfiguration.translate("blockui.config.default.number", defaultValue, min, max)).defineInRange(key, defaultValue, min, max);
    }

    protected ModConfigSpec.ConfigValue<String> defineString(String key, String defaultValue) {
        return this.buildBase(key, AbstractConfiguration.translate("blockui.config.default.string", defaultValue)).define(key, (Object)defaultValue);
    }

    protected ModConfigSpec.LongValue defineLong(String key, long defaultValue) {
        return this.defineLong(key, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    protected ModConfigSpec.LongValue defineLong(String key, long defaultValue, long min, long max) {
        return this.buildBase(key, AbstractConfiguration.translate("blockui.config.default.number", defaultValue, min, max)).defineInRange(key, defaultValue, min, max);
    }

    protected ModConfigSpec.DoubleValue defineDouble(String key, double defaultValue) {
        return this.defineDouble(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    protected ModConfigSpec.DoubleValue defineDouble(String key, double defaultValue, double min, double max) {
        return this.buildBase(key, AbstractConfiguration.translate("blockui.config.default.number", defaultValue, min, max)).defineInRange(key, defaultValue, min, max);
    }

    @Deprecated(since="1.21")
    protected <T> ModConfigSpec.ConfigValue<List<? extends T>> defineList(String key, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
        return this.buildBase(key, null).defineList(key, defaultValue, elementValidator);
    }

    protected <T> ModConfigSpec.ConfigValue<List<? extends T>> defineList(String key, Supplier<T> newUiInstance, Predicate<Object> elementValidator, List<? extends T> defaultValue) {
        return this.buildBase(key, null).defineList(key, defaultValue, newUiInstance, elementValidator);
    }

    protected <T> ModConfigSpec.ConfigValue<List<? extends T>> defineList(String key, Supplier<T> newUiInstance, Predicate<Object> elementValidator, T ... values) {
        return this.buildBase(key, null).defineList(key, () -> List.of(values), newUiInstance, elementValidator);
    }

    @Deprecated(since="1.21")
    protected <T> ModConfigSpec.ConfigValue<List<? extends T>> defineListAllowEmpty(String key, List<? extends T> defaultValue, Predicate<Object> elementValidator) {
        return this.buildBase(key, null).defineListAllowEmpty(key, defaultValue, elementValidator);
    }

    protected <T> ModConfigSpec.ConfigValue<List<? extends T>> defineListAllowEmpty(String key, Supplier<T> newUiInstance, Predicate<Object> elementValidator, List<? extends T> defaultValue) {
        return this.buildBase(key, null).defineListAllowEmpty(key, defaultValue, newUiInstance, elementValidator);
    }

    protected <T> ModConfigSpec.ConfigValue<List<? extends T>> defineListAllowEmpty(String key, Supplier<T> newUiInstance, Predicate<Object> elementValidator, T ... values) {
        return this.buildBase(key, null).defineListAllowEmpty(key, () -> List.of(values), newUiInstance, elementValidator);
    }

    protected <V extends Enum<V>> ModConfigSpec.EnumValue<V> defineEnum(String key, V defaultValue) {
        return this.buildBase(key, AbstractConfiguration.translate("blockui.config.default.enum", defaultValue, Arrays.stream((Enum[])defaultValue.getDeclaringClass().getEnumConstants()).map(Enum::name).collect(Collectors.joining(", ")))).defineEnum(key, defaultValue);
    }

    protected <T> void addWatcher(ModConfigSpec.ConfigValue<T> configValue, ConfigListener<T> listener) {
        this.watchers.add(new ConfigWatcher<T>(listener, configValue));
    }

    protected void addWatcher(Runnable listener, ModConfigSpec.ConfigValue<?> ... configValues) {
        ConfigListener<Object> typedListener = (o, n) -> listener.run();
        for (ModConfigSpec.ConfigValue<?> c : configValues) {
            this.watchers.add(new ConfigWatcher<Object>(typedListener, c));
        }
    }

    static class ConfigWatcher<T> {
        private final ConfigListener<T> listener;
        private final ModConfigSpec.ConfigValue<T> forgeConfig;
        @Nullable
        private T lastValue;

        private ConfigWatcher(ConfigListener<T> listener, ModConfigSpec.ConfigValue<T> forgeConfig) {
            this.listener = listener;
            this.forgeConfig = forgeConfig;
        }

        boolean isSameForgeConfig(ModConfigSpec.ConfigValue<?> other) {
            return other == this.forgeConfig;
        }

        synchronized void cacheLastValue() {
            this.lastValue = this.forgeConfig.get();
        }

        synchronized void compareAndFireChangeEvent() {
            Object newValue = this.forgeConfig.get();
            if (!Objects.equals(newValue, this.lastValue)) {
                ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(FMLEnvironment.dist.isClient() ? LogicalSide.CLIENT : LogicalSide.SERVER)).tell((Runnable)new TickTask(0, () -> this.listener.onChange(this.lastValue, newValue)));
                this.lastValue = newValue;
            }
        }
    }

    @FunctionalInterface
    public static interface ConfigListener<T> {
        public void onChange(T var1, T var2);
    }
}

