/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Tooltip;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIcon
extends Pane {
    @Nullable
    private Entity entity;
    private int count = 1;
    private float yaw = 30.0f;
    private float pitch = -10.0f;
    private float headyaw = 0.0f;

    public EntityIcon() {
    }

    public EntityIcon(PaneParams params) {
        super(params);
        ResourceLocation entityName = params.getResource("entity");
        if (entityName != null) {
            this.setEntity(entityName);
        }
        this.count = params.getInteger("count", this.count);
        this.yaw = params.getFloat("yaw", this.yaw);
        this.pitch = params.getFloat("pitch", this.pitch);
        this.headyaw = params.getFloat("head", this.headyaw);
    }

    public void setEntity(@NotNull ResourceLocation entityId) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId);
        if (entityType != null) {
            this.setEntity(entityType);
        } else {
            this.resetEntity();
        }
    }

    public void setEntity(@NotNull EntityType<?> type) {
        Entity entity = type.create((Level)this.mc.level);
        if (entity != null) {
            this.setEntity(entity);
        } else {
            this.resetEntity();
        }
    }

    public void setEntity(@NotNull Entity entity) {
        this.entity = entity;
        Pane pane = this.onHover;
        if (pane instanceof Tooltip.AutomaticTooltip) {
            Tooltip.AutomaticTooltip tooltip = (Tooltip.AutomaticTooltip)pane;
            tooltip.setText(this.entity.getDisplayName());
        }
    }

    public void resetEntity() {
        this.entity = null;
        Pane pane = this.onHover;
        if (pane instanceof Tooltip.AutomaticTooltip) {
            Tooltip.AutomaticTooltip tooltip = (Tooltip.AutomaticTooltip)pane;
            tooltip.clearText();
        }
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        PoseStack ms = target.pose();
        if (this.entity != null) {
            ms.pushPose();
            ms.translate((float)this.x, (float)this.y, -50.0f);
            AABB bb = this.entity.getBoundingBox();
            float scale = (float)((double)this.getHeight() / bb.getYsize() / 1.5);
            int cx = this.getWidth() / 2;
            int by = this.getHeight();
            int offsetY = 2;
            EntityIcon.drawEntity(ms, cx, by - 2, scale, this.headyaw, this.yaw, this.pitch, this.entity);
            if (this.count != 1) {
                String s = String.valueOf(this.count);
                ms.translate((double)this.getWidth(), (double)this.getHeight(), 100.0);
                ms.scale(0.75f, 0.75f, 0.75f);
                MultiBufferSource.BufferSource buffer = target.bufferSource();
                Font font = this.mc.font;
                float f = -4 - this.mc.font.width(s);
                Objects.requireNonNull(this.mc.font);
                font.drawInBatch(s, f, (float)(-9), 0xFFFFFF, true, ms.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                buffer.endBatch();
            }
            ms.popPose();
        }
    }

    @Override
    public void onUpdate() {
        if (this.onHover == null && this.entity != null) {
            new AbstractTextBuilder.AutomaticTooltipBuilder().hoverPane(this).build().setText(this.entity.getDisplayName());
        }
    }
}

