/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.CheckBox;
import com.ldtteam.blockui.controls.EntityIcon;
import com.ldtteam.blockui.controls.Gradient;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.ItemIconWithBlockState;
import com.ldtteam.blockui.controls.ItemIconWithProperties;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextFieldVanilla;
import com.ldtteam.blockui.controls.ToggleButton;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.Group;
import com.ldtteam.blockui.views.OverlayView;
import com.ldtteam.blockui.views.ScrollingGroup;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.SwitchView;
import com.ldtteam.blockui.views.View;
import com.ldtteam.blockui.views.ZoomDragView;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.loading.FMLEnvironment;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class Loader
extends SimplePreparableReloadListener<Map<ResourceLocation, PaneParams>> {
    public static final Loader INSTANCE = new Loader();
    private final Map<String, Function<PaneParams, ? extends Pane>> paneFactories = new HashMap<String, Function<PaneParams, ? extends Pane>>();
    private Map<ResourceLocation, PaneParams> xmlCache = new HashMap<ResourceLocation, PaneParams>();

    private Loader() {
        this.register("view", View::new);
        this.register("group", Group::new);
        this.register("scrollgroup", ScrollingGroup::new);
        this.register("list", ScrollingList::new);
        this.register("text", Text::new);
        this.register("button", ButtonImage::new);
        this.register("toggle", ToggleButton::new);
        this.register("input", TextFieldVanilla::new);
        this.register("image", Image::new);
        this.register("box", Box::new);
        this.register("itemicon", Loader::itemIcon);
        this.register("entityicon", EntityIcon::new);
        this.register("switch", SwitchView::new);
        this.register("dropdown", DropDownList::new);
        this.register("overlay", OverlayView::new);
        this.register("gradient", Gradient::new);
        this.register("zoomdragview", ZoomDragView::new);
        this.register("checkbox", CheckBox::new);
    }

    private static ItemIcon itemIcon(PaneParams paneParams) {
        if (paneParams.hasAttribute("nbt")) {
            if (!FMLEnvironment.production && paneParams.hasAttribute("properties")) {
                throw new IllegalStateException("Must be one of '%s' or '%s'".formatted("nbt", "properties"));
            }
            return new ItemIconWithBlockState(paneParams);
        }
        if (paneParams.hasAttribute("properties")) {
            return new ItemIconWithProperties(paneParams);
        }
        return new ItemIcon(paneParams);
    }

    public void register(String name, Function<PaneParams, ? extends Pane> factoryMethod) {
        if (this.paneFactories.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate pane type '" + name + "' when registering Pane class method.");
        }
        this.paneFactories.put(name, factoryMethod);
    }

    private Pane createFromPaneParams(PaneParams params) {
        String name = params.getType();
        if (this.paneFactories.containsKey(name)) {
            return this.paneFactories.get(name).apply(params);
        }
        Log.getLogger().error("There is no factory method for " + name);
        return null;
    }

    public static Pane createFromPaneParams(PaneParams params, View parent) {
        if ("layout".equalsIgnoreCase(params.getType())) {
            params.getResource("source", r -> Loader.createFromXMLFile(r, parent));
            return null;
        }
        if (parent instanceof BOWindow) {
            BOWindow window = (BOWindow)parent;
            if (params.getType().equals("window")) {
                window.loadParams(params);
                parent.parseChildren(params);
                return parent;
            }
        }
        if (parent instanceof View && params.getType().equals("window")) {
            parent.parseChildren(params);
            return parent;
        }
        params.setParentView(parent);
        Pane pane = INSTANCE.createFromPaneParams(params);
        if (pane != null) {
            pane.putInside(parent);
            pane.parseChildren(params);
        }
        return pane;
    }

    public static Pane createFromXMLFile(ResourceLocation resource, View parent) {
        if (Loader.INSTANCE.xmlCache.containsKey(resource)) {
            try {
                return Loader.createFromPaneParams(Loader.INSTANCE.xmlCache.get(resource), parent);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't parse xml at: " + resource.toString(), e);
            }
        }
        throw new RuntimeException("Gui at \"" + resource.toString() + "\" was not found!");
    }

    protected Map<ResourceLocation, PaneParams> prepare(ResourceManager rm, ProfilerFiller profiler) {
        DocumentBuilder documentBuilder;
        profiler.startTick();
        profiler.push("BlockUI-xml-lookup-parsing");
        HashMap<ResourceLocation, PaneParams> foundXmls = new HashMap<ResourceLocation, PaneParams>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            profiler.pop();
            profiler.endTick();
            throw new RuntimeException(e);
        }
        rm.listResources("gui", rl -> rl.getPath().endsWith(".xml")).forEach((rl, res) -> {
            Document doc;
            try (InputStream is = res.open();){
                doc = documentBuilder.parse(is);
            }
            catch (IOException | SAXException e) {
                Log.getLogger().error("Failed to load xml at: " + rl.toString(), (Throwable)e);
                return;
            }
            doc.getDocumentElement().normalize();
            foundXmls.put((ResourceLocation)rl, new PaneParams(doc.getDocumentElement()));
        });
        profiler.pop();
        profiler.endTick();
        return foundXmls;
    }

    protected void apply(Map<ResourceLocation, PaneParams> foundXmls, ResourceManager rm, ProfilerFiller profiler) {
        this.xmlCache = foundXmls;
    }
}

