/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerTubeOrientation;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.misc.MiscDirs;

@CullTest(value={BlockType.FRAMED_CORNER_TUBE})
public final class CornerTubeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        CornerTubeOrientation orientation = (CornerTubeOrientation)((Object)state.getValue(PropertyHolder.CORNER_TYPE_ORIENTATION));
        if (MiscDirs.CornerTube.testEarlyExit(orientation, side)) {
            return false;
        }
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            boolean thick = (Boolean)state.getValue((Property)PropertyHolder.THICK);
            return switch (blockType) {
                case BlockType.FRAMED_CORNER_TUBE -> CornerTubeSkipPredicate.testAgainstCornerTube(orientation, thick, adjState, side);
                case BlockType.FRAMED_TUBE -> CornerTubeSkipPredicate.testAgainstTube(orientation, thick, adjState, side);
                case BlockType.FRAMED_HOPPER -> CornerTubeSkipPredicate.testAgainstHopper(orientation, thick, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_TUBE})
    private static boolean testAgainstCornerTube(CornerTubeOrientation orientation, boolean thick, BlockState adjState, Direction side) {
        CornerTubeOrientation adjOrientation = (CornerTubeOrientation)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE_ORIENTATION));
        boolean adjThick = (Boolean)adjState.getValue((Property)PropertyHolder.THICK);
        return MiscDirs.CornerTube.getOpeningDir(orientation, thick, side).isEqualTo(MiscDirs.CornerTube.getOpeningDir(adjOrientation, adjThick, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_TUBE})
    private static boolean testAgainstTube(CornerTubeOrientation orientation, boolean thick, BlockState adjState, Direction side) {
        Direction.Axis adjAxis = (Direction.Axis)adjState.getValue((Property)BlockStateProperties.AXIS);
        boolean adjThick = (Boolean)adjState.getValue((Property)PropertyHolder.THICK);
        return MiscDirs.CornerTube.getOpeningDir(orientation, thick, side).isEqualTo(MiscDirs.Tube.getOpeningDir(adjAxis, adjThick, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HOPPER})
    private static boolean testAgainstHopper(CornerTubeOrientation orientation, boolean thick, Direction side) {
        return MiscDirs.CornerTube.getOpeningDir(orientation, thick, side).isEqualTo(MiscDirs.Hopper.getOpeningDir(side.getOpposite()));
    }
}

