/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;

public final class SlopePanelShapes
implements SplitShapeGenerator {
    public static final ShapeCache<SlopePanelShape> SHAPES = SlopePanelShapes.makeCache(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0)));
    public static final ShapeCache<SlopePanelShape> OCCLUSION_SHAPES = SlopePanelShapes.makeCache(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)8.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)7.75), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)));

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return SlopePanelShapes.generate(states, SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return SlopePanelShapes.generate(states, OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<SlopePanelShape> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskFront = 16;
        VoxelShape[] shapes = new VoxelShape[32];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shape = cache.get(SlopePanelShape.get(rot, false));
            VoxelShape shapeFront = cache.get(SlopePanelShape.get(rot, true));
            ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, shapes, rot.ordinal() << 2);
            ShapeUtils.makeHorizontalRotations(shapeFront, Direction.NORTH, shapes, maskFront | rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int front = (Boolean)state.getValue((Property)PropertyHolder.FRONT) != false ? maskFront : 0;
            int idx = dir.get2DDataValue() | rot.ordinal() << 2 | front;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<SlopePanelShape> makeCache(Supplier<VoxelShape> upShapeFactory) {
        return ShapeCache.createEnum(SlopePanelShape.class, map -> {
            VoxelShape shapeUp = (VoxelShape)upShapeFactory.get();
            map.put(SlopePanelShape.UP_BACK, shapeUp);
            map.put(SlopePanelShape.UP_FRONT, shapeUp.move(0.0, 0.0, 0.5));
            VoxelShape shapeRight = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.UP, Direction.EAST, shapeUp);
            map.put(SlopePanelShape.RIGHT_BACK, shapeRight);
            map.put(SlopePanelShape.RIGHT_FRONT, shapeRight.move(0.0, 0.0, 0.5));
            VoxelShape shapeDown = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.UP, Direction.DOWN, shapeUp);
            map.put(SlopePanelShape.DOWN_BACK, shapeDown);
            map.put(SlopePanelShape.DOWN_FRONT, shapeDown.move(0.0, 0.0, 0.5));
            VoxelShape shapeLeft = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.UP, Direction.WEST, shapeUp);
            map.put(SlopePanelShape.LEFT_BACK, shapeLeft);
            map.put(SlopePanelShape.LEFT_FRONT, shapeLeft.move(0.0, 0.0, 0.5));
        });
    }
}

