/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopeedge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopeedge.SlopeEdgeShapes;

public final class ThreewayCornerSlopeEdgeShapes
implements SplitShapeGenerator {
    public static final ShapeCache<ShapeKey> OUTER_SHAPES = ThreewayCornerSlopeEdgeShapes.makeCache(SlopeEdgeShapes.SHAPES, false);
    public static final ShapeCache<ShapeKey> OUTER_OCCLUSION_SHAPES = ThreewayCornerSlopeEdgeShapes.makeCache(SlopeEdgeShapes.OCCLUSION_SHAPES, false);
    public static final ShapeCache<ShapeKey> INNER_SHAPES = ThreewayCornerSlopeEdgeShapes.makeCache(SlopeEdgeShapes.SHAPES, true);
    public static final ShapeCache<ShapeKey> INNER_OCCLUSION_SHAPES = ThreewayCornerSlopeEdgeShapes.makeCache(SlopeEdgeShapes.OCCLUSION_SHAPES, true);
    public static final ThreewayCornerSlopeEdgeShapes OUTER = new ThreewayCornerSlopeEdgeShapes(false);
    public static final ThreewayCornerSlopeEdgeShapes INNER = new ThreewayCornerSlopeEdgeShapes(true);
    private final boolean inner;

    private ThreewayCornerSlopeEdgeShapes(boolean inner) {
        this.inner = inner;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return ThreewayCornerSlopeEdgeShapes.generate(states, this.inner ? INNER_SHAPES : OUTER_SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return ThreewayCornerSlopeEdgeShapes.generate(states, this.inner ? INNER_OCCLUSION_SHAPES : OUTER_OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<ShapeKey> cache) {
        VoxelShape[] shapes = new VoxelShape[16];
        for (int i = 0; i < 4; ++i) {
            boolean altType = (i & 1) != 0;
            ShapeUtils.makeHorizontalRotationsWithFlag(cache.get(new ShapeKey(false, altType)), cache.get(new ShapeKey(true, altType)), Direction.NORTH, altType, shapes, ThreewayCornerSlopeEdgeShapes::makeShapeIndex);
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            if (((Boolean)state.getValue((Property)PropertyHolder.RIGHT)).booleanValue()) {
                dir = dir.getClockWise();
            }
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            boolean altType = (Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE);
            builder.put((Object)state, (Object)shapes[ThreewayCornerSlopeEdgeShapes.makeShapeIndex(dir, top, altType)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static int makeShapeIndex(Direction dir, boolean top, boolean altType) {
        return dir.get2DDataValue() << 2 | (top ? 2 : 0) | (altType ? 1 : 0);
    }

    private static ShapeCache<ShapeKey> makeCache(ShapeCache<SlopeEdgeShapes.ShapeKey> cache, boolean inner) {
        return ShapeCache.create(map -> {
            VoxelShape edgeShapeHor = cache.get(new SlopeEdgeShapes.ShapeKey(SlopeType.HORIZONTAL, false));
            VoxelShape edgeShapeBottom = cache.get(new SlopeEdgeShapes.ShapeKey(SlopeType.BOTTOM, false));
            VoxelShape edgeShapeTop = cache.get(new SlopeEdgeShapes.ShapeKey(SlopeType.TOP, false));
            map.put(new ShapeKey(false, false), ThreewayCornerSlopeEdgeShapes.makeCornerShape(edgeShapeBottom, edgeShapeHor, inner));
            map.put(new ShapeKey(true, false), ThreewayCornerSlopeEdgeShapes.makeCornerShape(edgeShapeTop, edgeShapeHor, inner));
            VoxelShape edgeShapeHorAlt = cache.get(new SlopeEdgeShapes.ShapeKey(SlopeType.HORIZONTAL, true));
            VoxelShape edgeShapeBottomAlt = cache.get(new SlopeEdgeShapes.ShapeKey(SlopeType.BOTTOM, true));
            VoxelShape edgeShapeTopAlt = cache.get(new SlopeEdgeShapes.ShapeKey(SlopeType.TOP, true));
            map.put(new ShapeKey(false, true), ThreewayCornerSlopeEdgeShapes.makeAltCornerShape(edgeShapeBottomAlt, edgeShapeHorAlt, inner, false));
            map.put(new ShapeKey(true, true), ThreewayCornerSlopeEdgeShapes.makeAltCornerShape(edgeShapeTopAlt, edgeShapeHorAlt, inner, true));
        });
    }

    private static VoxelShape makeCornerShape(VoxelShape edgeShape, VoxelShape edgeShapeHor, boolean inner) {
        VoxelShape edgeShapeRot = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, edgeShape);
        BooleanOp joinOp = inner ? BooleanOp.OR : BooleanOp.AND;
        return Shapes.joinUnoptimized((VoxelShape)Shapes.joinUnoptimized((VoxelShape)edgeShape, (VoxelShape)edgeShapeRot, (BooleanOp)joinOp), (VoxelShape)edgeShapeHor, (BooleanOp)joinOp);
    }

    private static VoxelShape makeAltCornerShape(VoxelShape edgeShape, VoxelShape edgeShapeHor, boolean inner, boolean top) {
        VoxelShape edgeShapeRot = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, edgeShape);
        VoxelShape mask = Shapes.box((double)0.5, (double)(top ? 0.0 : 0.5), (double)0.5, (double)1.0, (double)(top ? 0.5 : 1.0), (double)1.0);
        if (inner) {
            return ShapeUtils.andUnoptimized(ShapeUtils.orUnoptimized(edgeShape, edgeShapeRot, edgeShapeHor), mask);
        }
        return ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(edgeShape, edgeShapeRot, edgeShapeHor), ShapeUtils.andUnoptimized(ShapeUtils.orUnoptimized(edgeShape, edgeShapeRot, edgeShapeHor), Shapes.joinUnoptimized((VoxelShape)Shapes.block(), (VoxelShape)mask, (BooleanOp)BooleanOp.ONLY_FIRST)));
    }

    public record ShapeKey(boolean top, boolean altType) {
    }
}

