/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slope.SlopeShapes;

public final class CornerSlopeShapes
implements SplitShapeGenerator {
    public static final CornerSlopeShapes OUTER = new CornerSlopeShapes(BooleanOp.AND);
    public static final CornerSlopeShapes INNER = new CornerSlopeShapes(BooleanOp.OR);
    private final BooleanOp joinOp;

    private CornerSlopeShapes(BooleanOp joinOp) {
        this.joinOp = joinOp;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return this.generate(states, SlopeShapes.SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return this.generate(states, SlopeShapes.OCCLUSION_SHAPES);
    }

    private ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<SlopeType> shapeCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeSlopeBottom = shapeCache.get(SlopeType.BOTTOM);
        VoxelShape shapeSlopeTop = shapeCache.get(SlopeType.TOP);
        VoxelShape shapeSlopeHorizontal = shapeCache.get(SlopeType.HORIZONTAL);
        VoxelShape shapeSlopeHorizontalEast = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, shapeSlopeHorizontal);
        VoxelShape shapeTop = Shapes.joinUnoptimized((VoxelShape)shapeSlopeTop, (VoxelShape)ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, shapeSlopeTop), (BooleanOp)this.joinOp);
        VoxelShape shapeBottom = Shapes.joinUnoptimized((VoxelShape)shapeSlopeBottom, (VoxelShape)ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, shapeSlopeBottom), (BooleanOp)this.joinOp);
        VoxelShape shapeBottomLeft = Shapes.joinUnoptimized((VoxelShape)shapeSlopeBottom, (VoxelShape)shapeSlopeHorizontal, (BooleanOp)this.joinOp);
        VoxelShape shapeBottomRight = Shapes.joinUnoptimized((VoxelShape)shapeSlopeBottom, (VoxelShape)shapeSlopeHorizontalEast, (BooleanOp)this.joinOp);
        VoxelShape shapeTopLeft = Shapes.joinUnoptimized((VoxelShape)shapeSlopeTop, (VoxelShape)shapeSlopeHorizontal, (BooleanOp)this.joinOp);
        VoxelShape shapeTopRight = Shapes.joinUnoptimized((VoxelShape)shapeSlopeTop, (VoxelShape)shapeSlopeHorizontalEast, (BooleanOp)this.joinOp);
        HashMap shapes = new HashMap();
        for (CornerType type : CornerType.values()) {
            VoxelShape shape = switch (type) {
                default -> throw new MatchException(null, null);
                case CornerType.BOTTOM -> shapeBottom;
                case CornerType.TOP -> shapeTop;
                case CornerType.HORIZONTAL_BOTTOM_LEFT -> shapeBottomLeft;
                case CornerType.HORIZONTAL_BOTTOM_RIGHT -> shapeBottomRight;
                case CornerType.HORIZONTAL_TOP_LEFT -> shapeTopLeft;
                case CornerType.HORIZONTAL_TOP_RIGHT -> shapeTopRight;
            };
            ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, shapes, type, ShapeKey::new);
        }
        for (BlockState state : states) {
            CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)((VoxelShape)shapes.get(new ShapeKey(dir, type))));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private record ShapeKey(Direction dir, CornerType type) {
    }
}

